/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.canon.runtime.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.symphonyoss.s2.canon.runtime.IModelRegistry;
import org.symphonyoss.s2.canon.runtime.http.AbstractRequestContext;
import org.symphonyoss.s2.canon.runtime.http.HttpMethod;
import org.symphonyoss.s2.canon.runtime.http.IAsyncRequestContext;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;

public class ServletRequestContext
extends AbstractRequestContext
implements IAsyncRequestContext {
    private final HttpServletRequest request_;
    private final HttpServletResponse response_;
    private Map<String, Cookie> cookieMap_;
    private Map<String, String> pathMap_;

    public ServletRequestContext(HttpMethod method, ITraceContext trace, IModelRegistry modelRegistry, HttpServletRequest request, HttpServletResponse response) {
        super(method, trace, modelRegistry);
        this.request_ = request;
        this.response_ = response;
    }

    @Override
    protected synchronized String getCookie(String name) {
        if (this.cookieMap_ == null) {
            this.cookieMap_ = new HashMap<String, Cookie>();
            for (Cookie cookie : this.request_.getCookies()) {
                this.cookieMap_.put(cookie.getName(), cookie);
            }
        }
        return this.cookieMap_.get(name).getValue();
    }

    @Override
    protected String getHeader(String name) {
        return this.request_.getHeader(name);
    }

    @Override
    public String getPathInfo() {
        return this.request_.getPathInfo();
    }

    @Override
    protected String getParameter(String name) {
        return this.request_.getParameter(name);
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return this.request_.getReader();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this.response_.getWriter();
    }

    @Override
    public void setContentType(String type) {
        this.response_.setContentType(type);
    }

    @Override
    public void setStatus(int sc) {
        this.response_.setStatus(sc);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.response_.sendError(sc, msg);
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return this.request_.getInputStream();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this.response_.getOutputStream();
    }

    @Override
    public AsyncContext startAsync() {
        return this.request_.startAsync();
    }
}

