/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.annotation.Nullable;
import org.symphonyoss.s2.common.crypto.cert.Certificate;
import org.symphonyoss.s2.common.crypto.cert.ICertificate;
import org.symphonyoss.s2.common.crypto.cert.IOpenCertificate;
import org.symphonyoss.s2.common.crypto.cert.IntCert;
import org.symphonyoss.s2.common.crypto.cert.IntSigningCert;
import org.symphonyoss.s2.common.crypto.cert.IntSigningWrappingCert;
import org.symphonyoss.s2.common.crypto.cert.IntWrappingCert;
import org.symphonyoss.s2.common.crypto.cert.MasterCert;
import org.symphonyoss.s2.common.crypto.cert.MasterSigningCert;
import org.symphonyoss.s2.common.crypto.cert.MasterSigningWrappingCert;
import org.symphonyoss.s2.common.crypto.cert.MasterWrappingCert;
import org.symphonyoss.s2.common.crypto.cert.OpenCert;
import org.symphonyoss.s2.common.crypto.cert.SignatureVerificationCert;
import org.symphonyoss.s2.common.crypto.cert.SigningCert;
import org.symphonyoss.s2.common.crypto.cert.SigningWrappingCert;
import org.symphonyoss.s2.common.crypto.cert.WrappingCert;
import org.symphonyoss.s2.common.crypto.cipher.UnknownCipherSuiteException;

public class CertificateFactory {
    public static ICertificate loadCertificate(String certChain) throws CertificateException, UnknownCipherSuiteException {
        return CertificateFactory.typedCertificate(new Certificate(certChain));
    }

    public static ICertificate typedCertificate(Certificate cert) {
        boolean signingCert = false;
        boolean certSigningCert = false;
        boolean masterSigningCert = false;
        boolean keyWrappingCert = false;
        boolean openCert = cert.getPrivateKey() != null;
        X509Certificate x509Cert = cert.getX509Certificate();
        boolean[] keyUsage = x509Cert.getKeyUsage();
        keyWrappingCert = openCert && CertificateFactory.hasKeyUsage(keyUsage, 2);
        signingCert = CertificateFactory.hasKeyUsage(keyUsage, 0);
        certSigningCert = openCert && CertificateFactory.hasKeyUsage(keyUsage, 5) && x509Cert.getBasicConstraints() >= 0;
        boolean bl = masterSigningCert = openCert && certSigningCert && x509Cert.getBasicConstraints() > 0;
        if (masterSigningCert) {
            if (signingCert) {
                if (keyWrappingCert) {
                    return new MasterSigningWrappingCert(cert);
                }
                return new MasterSigningCert(cert);
            }
            if (keyWrappingCert) {
                return new MasterWrappingCert(cert);
            }
            return new MasterCert(cert);
        }
        if (certSigningCert) {
            if (signingCert) {
                if (keyWrappingCert) {
                    return new IntSigningWrappingCert(cert);
                }
                return new IntSigningCert(cert);
            }
            if (keyWrappingCert) {
                return new IntWrappingCert(cert);
            }
            return new IntCert(cert);
        }
        if (signingCert) {
            if (keyWrappingCert) {
                return new SigningWrappingCert(cert);
            }
            if (openCert) {
                return new SigningCert(cert);
            }
            return new SignatureVerificationCert(cert);
        }
        if (keyWrappingCert) {
            return new WrappingCert(cert);
        }
        if (cert.getPrivateKey() != null) {
            return new OpenCert(cert);
        }
        return cert;
    }

    private static boolean hasKeyUsage(boolean[] keyUsage, int i) {
        return keyUsage == null || keyUsage.length >= i && keyUsage[i];
    }

    public static IOpenCertificate loadOpenCertificate(String certChain, String encryptedKey, @Nullable char[] passPhrase) throws CertificateException, UnknownCipherSuiteException {
        return (IOpenCertificate)CertificateFactory.typedCertificate(new Certificate(certChain, encryptedKey, passPhrase));
    }

    public static ICertificate load(File file, String storeType, @Nullable String alias, char[] password) throws IOException, GeneralSecurityException, UnknownCipherSuiteException {
        try (FileInputStream in = new FileInputStream(file);){
            ICertificate iCertificate = CertificateFactory.load(in, storeType, alias, password);
            return iCertificate;
        }
    }

    public static ICertificate load(InputStream in, String storeType, @Nullable String alias, char[] password) throws IOException, GeneralSecurityException, UnknownCipherSuiteException {
        KeyStore keyStore = KeyStore.getInstance(storeType);
        keyStore.load(in, password);
        if (alias == null) {
            Enumeration<String> it = keyStore.aliases();
            if (it.hasMoreElements()) {
                alias = it.nextElement();
            } else {
                throw new IOException("Keystore is empty");
            }
        }
        PrivateKey privateKey = null;
        if (keyStore.isKeyEntry(alias)) {
            Key key = keyStore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                privateKey = (PrivateKey)key;
            } else {
                throw new CertificateException("Alias \"" + alias + "\" is a " + key.getClass().getName() + " entry.");
            }
        }
        java.security.cert.Certificate[] certChain = keyStore.getCertificateChain(alias);
        X509Certificate[] x509CertChain = new X509Certificate[certChain.length];
        for (int i = 0; i < certChain.length; ++i) {
            if (!(certChain[i] instanceof X509Certificate)) {
                throw new CertificateException("Alias \"" + alias + "\" is a " + certChain[i].getClass().getName() + " entry.");
            }
            x509CertChain[i] = (X509Certificate)certChain[i];
        }
        return CertificateFactory.typedCertificate(new Certificate(x509CertChain, privateKey));
    }
}

