/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.symphonyoss.s2.common.fault.CodingFault;
import org.symphonyoss.s2.common.type.IPersistentEnum;
import org.symphonyoss.s2.common.type.InvalidPersistentEnumException;

public enum CertType implements IPersistentEnum
{
    ANY(0),
    Master(1),
    Intermediate(2),
    UserEncryption(3),
    NewAccount(4),
    UserSigning(5),
    UserAttribute(6),
    Server(7),
    Node(8);

    private static Map<Integer, CertType> idMap_;
    private final int id_;

    private CertType(int id) {
        this.id_ = id;
    }

    public int toInt() {
        return this.id_;
    }

    @Nonnull
    public static CertType newInstance(int id) throws InvalidPersistentEnumException {
        CertType v = idMap_.get(id);
        if (v == null) {
            throw new InvalidPersistentEnumException("Invalid CertType ID " + id);
        }
        return v;
    }

    static {
        idMap_ = new HashMap<Integer, CertType>();
        for (CertType v : CertType.values()) {
            if (idMap_.containsKey(v.toInt())) {
                throw new CodingFault("Duplicate id " + v.toInt());
            }
            idMap_.put(v.toInt(), v);
        }
    }
}

