/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.symphonyoss.s2.common.crypto.cipher.Aes128CipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.Aes192CipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.Aes256CipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.Aes256GCMCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.AsymmetricCipher;
import org.symphonyoss.s2.common.crypto.cipher.Ecc521CipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.IAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.ISymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.Rsa1024CipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.Rsa2048CipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.SymmetricCipher;
import org.symphonyoss.s2.common.crypto.cipher.UnknownCipherSuiteException;
import org.symphonyoss.s2.common.fault.CodingFault;
import org.symphonyoss.s2.common.fault.ProgramFault;

public class CipherSuite {
    private static final Map<String, IAsymmetricCipherSuite> publicAlgoMap_ = new HashMap<String, IAsymmetricCipherSuite>();
    private static final Map<String, ISymmetricCipherSuite> secretAlgoMap_ = new HashMap<String, ISymmetricCipherSuite>();
    private static final Map<String, Map<Integer, IAsymmetricCipherSuite>> publicAlgoSizeMap_ = new HashMap<String, Map<Integer, IAsymmetricCipherSuite>>();
    private static final Map<String, Map<Integer, ISymmetricCipherSuite>> secretAlgoSizeMap_ = new HashMap<String, Map<Integer, ISymmetricCipherSuite>>();
    private static final Map<AsymmetricCipher, IAsymmetricCipherSuite> publicMap_ = new HashMap<AsymmetricCipher, IAsymmetricCipherSuite>();
    private static final Map<SymmetricCipher, ISymmetricCipherSuite> secretMap_ = new HashMap<SymmetricCipher, ISymmetricCipherSuite>();
    private static final List<IAsymmetricCipherSuite> publicList_;
    private static final List<ISymmetricCipherSuite> secretList_;
    private static final ISymmetricCipherSuite defaultSymmetricCipherSuite_;
    private static final IAsymmetricCipherSuite defaultAsymmetricCipherSuite_;
    private static List<IAsymmetricCipherSuite> publicBuildList_;
    private static List<ISymmetricCipherSuite> secretBuildList_;

    private static void register(ISymmetricCipherSuite cipherSuite) {
        secretMap_.put(cipherSuite.getId(), cipherSuite);
        secretAlgoMap_.put(cipherSuite.getKeyAlgorithm(), cipherSuite);
        Map<Integer, ISymmetricCipherSuite> map = secretAlgoSizeMap_.get(cipherSuite.getKeyAlgorithm());
        if (map == null) {
            map = new HashMap<Integer, ISymmetricCipherSuite>();
            secretAlgoSizeMap_.put(cipherSuite.getKeyAlgorithm(), map);
        }
        if (!map.containsKey(cipherSuite.getKeySize())) {
            map.put(cipherSuite.getKeySize(), cipherSuite);
        }
        secretBuildList_.add(cipherSuite);
    }

    private static void register(IAsymmetricCipherSuite cipherSuite) {
        publicMap_.put(cipherSuite.getId(), cipherSuite);
        publicAlgoMap_.put(cipherSuite.getKeyAlgorithm(), cipherSuite);
        Map<Integer, IAsymmetricCipherSuite> map = publicAlgoSizeMap_.get(cipherSuite.getKeyAlgorithm());
        if (map == null) {
            map = new HashMap<Integer, IAsymmetricCipherSuite>();
            publicAlgoSizeMap_.put(cipherSuite.getKeyAlgorithm(), map);
        }
        if (!map.containsKey(cipherSuite.getKeySize())) {
            map.put(cipherSuite.getKeySize(), cipherSuite);
        }
        publicBuildList_.add(cipherSuite);
    }

    @Nonnull
    public static IAsymmetricCipherSuite get(PublicKey key) throws UnknownCipherSuiteException {
        int keySize;
        IAsymmetricCipherSuite cipherSuite = publicAlgoMap_.get(key.getAlgorithm());
        if (cipherSuite == null) {
            throw new UnknownCipherSuiteException("Unknown algorithm \"" + key.getAlgorithm() + "\"");
        }
        try {
            keySize = cipherSuite.getKeySize(key);
        }
        catch (InvalidKeyException e) {
            throw new UnknownCipherSuiteException("Unsupported key size \"" + key.getAlgorithm() + "\"");
        }
        cipherSuite = publicAlgoSizeMap_.get(key.getAlgorithm()).get(keySize);
        if (cipherSuite == null) {
            throw new UnknownCipherSuiteException("Unsupported key size \"" + key.getAlgorithm() + "\" " + keySize);
        }
        return cipherSuite;
    }

    @Nonnull
    public static ISymmetricCipherSuite get(SecretKey key) throws UnknownCipherSuiteException {
        ISymmetricCipherSuite cipherSuite = secretAlgoMap_.get(key.getAlgorithm());
        if (cipherSuite == null) {
            throw new UnknownCipherSuiteException("Unknown algorithm \"" + key.getAlgorithm() + "\"");
        }
        int keySize = cipherSuite.getKeySize(key);
        cipherSuite = secretAlgoSizeMap_.get(key.getAlgorithm()).get(keySize);
        if (cipherSuite == null) {
            throw new UnknownCipherSuiteException("Unsupported key size \"" + key.getAlgorithm() + "\" " + keySize);
        }
        return cipherSuite;
    }

    @Nonnull
    public static IAsymmetricCipherSuite get(AsymmetricCipher id) {
        if (!publicMap_.containsKey((Object)id)) {
            throw new CodingFault("No cipher suite for " + (Object)((Object)id));
        }
        return publicMap_.get((Object)id);
    }

    @Nonnull
    public static ISymmetricCipherSuite get(SymmetricCipher id) {
        if (!secretMap_.containsKey((Object)id)) {
            throw new CodingFault("No cipher suite for " + (Object)((Object)id));
        }
        return secretMap_.get((Object)id);
    }

    @Nonnull
    public static IAsymmetricCipherSuite getAsymmetricCipher() {
        return defaultAsymmetricCipherSuite_;
    }

    @Nonnull
    public static ISymmetricCipherSuite getSymmetricCipher() {
        return defaultSymmetricCipherSuite_;
    }

    public static List<IAsymmetricCipherSuite> getAllAsymetricCipherSuites() {
        return publicList_;
    }

    public static List<ISymmetricCipherSuite> getAllSymetricCipherSuites() {
        return secretList_;
    }

    static {
        publicBuildList_ = new ArrayList<IAsymmetricCipherSuite>();
        secretBuildList_ = new ArrayList<ISymmetricCipherSuite>();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            defaultSymmetricCipherSuite_ = new Aes256GCMCipherSuite(SymmetricCipher.AES256_GCM);
            defaultAsymmetricCipherSuite_ = new Rsa2048CipherSuite(AsymmetricCipher.RSA2048);
            CipherSuite.register(defaultSymmetricCipherSuite_);
            CipherSuite.register(new Aes128CipherSuite(SymmetricCipher.AES128_CBC));
            CipherSuite.register(new Aes192CipherSuite(SymmetricCipher.AES192_CBC));
            CipherSuite.register(new Aes256CipherSuite(SymmetricCipher.AES256_CBC));
            CipherSuite.register(defaultAsymmetricCipherSuite_);
            CipherSuite.register(new Rsa1024CipherSuite(AsymmetricCipher.RSA1024));
            CipherSuite.register(new Ecc521CipherSuite(AsymmetricCipher.ECC521));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | OperatorCreationException e) {
            throw new ProgramFault(e);
        }
        publicList_ = Collections.unmodifiableList(publicBuildList_);
        secretList_ = Collections.unmodifiableList(secretBuildList_);
    }
}

