/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.OperatorCreationException;
import org.symphonyoss.s2.common.crypto.cipher.AbstractAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.AsymmetricCipher;
import org.symphonyoss.s2.common.crypto.cipher.IAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.ISymmetricCipherSuite;

class Ecc521CipherSuite
extends AbstractAsymmetricCipherSuite
implements IAsymmetricCipherSuite {
    private static final String KEY_ALGORITHM = "EC";
    private static final String SIGNATURE_ALGORITHM = "SHA512withECDSA";
    private static final String PROVIDER = "BC";
    private static final String CURVE_NAME = "secp521r1";
    private static final String WRAPPING_CIPHER_SPEC = "ECIESwithAES";
    private ECGenParameterSpec ecGenSpec;
    private KeyPairGenerator keyGen_;
    private SecureRandom rand_ = new SecureRandom();

    public Ecc521CipherSuite(AsymmetricCipher id) throws NoSuchAlgorithmException, NoSuchProviderException, OperatorCreationException, InvalidAlgorithmParameterException {
        super(id);
        this.ecGenSpec = new ECGenParameterSpec(CURVE_NAME);
        this.keyGen_ = KeyPairGenerator.getInstance(KEY_ALGORITHM, PROVIDER);
        this.keyGen_.initialize(this.ecGenSpec, this.rand_);
    }

    @Override
    public String getKeyAlgorithm() {
        return KEY_ALGORITHM;
    }

    @Override
    public Cipher getCipher() throws GeneralSecurityException {
        return Cipher.getInstance(WRAPPING_CIPHER_SPEC, PROVIDER);
    }

    @Override
    public int getKeySize() {
        return 521;
    }

    @Override
    public KeyPair generateKeyPair() {
        return this.keyGen_.generateKeyPair();
    }

    @Override
    public byte[] wrap(SecretKey key, PublicKey userKey) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        cipher.init(1, (Key)userKey, this.rand_);
        return cipher.doFinal(key.getEncoded());
    }

    @Override
    public SecretKey unwrap(byte[] cipherText, PrivateKey userPrivateKey, ISymmetricCipherSuite symmetricCipherSuite) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        cipher.init(2, (Key)userPrivateKey, this.rand_);
        byte[] encoded = cipher.doFinal(cipherText);
        return new SecretKeySpec(encoded, symmetricCipherSuite.getKeyAlgorithm());
    }

    @Override
    public String getSignatureAlgorithm() {
        return SIGNATURE_ALGORITHM;
    }

    @Override
    public PublicKey publicKeyFromDER(String der) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        try (StringReader reader = new StringReader(der);){
            PublicKey publicKey;
            PEMParser pemParser = new PEMParser((Reader)reader);
            Throwable throwable2 = null;
            try {
                Object o = pemParser.readObject();
                if (o == null || !(o instanceof SubjectPublicKeyInfo)) {
                    throw new IOException("Not an OpenSSL public key");
                }
                publicKey = KeyFactory.getInstance(KEY_ALGORITHM, PROVIDER).generatePublic(new X509EncodedKeySpec(((SubjectPublicKeyInfo)o).getEncoded()));
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        Ecc521CipherSuite.$closeResource(throwable2, (AutoCloseable)pemParser);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            Ecc521CipherSuite.$closeResource(throwable2, (AutoCloseable)pemParser);
            return publicKey;
        }
    }

    @Override
    public PrivateKey privateKeyFromDER(String der) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        try (StringReader reader = new StringReader(der);){
            PrivateKey privateKey;
            PEMParser pemParser = new PEMParser((Reader)reader);
            Throwable throwable2 = null;
            try {
                Object o = pemParser.readObject();
                if (o == null || !(o instanceof PEMKeyPair)) {
                    throw new IOException("Not an OpenSSL key");
                }
                privateKey = KeyFactory.getInstance(KEY_ALGORITHM, PROVIDER).generatePrivate(new PKCS8EncodedKeySpec(((PEMKeyPair)o).getPrivateKeyInfo().getEncoded()));
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        Ecc521CipherSuite.$closeResource(throwable2, (AutoCloseable)pemParser);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            Ecc521CipherSuite.$closeResource(throwable2, (AutoCloseable)pemParser);
            return privateKey;
        }
    }

    @Override
    public int getKeySize(PublicKey key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            ECParameterSpec spec = ((ECPublicKey)key).getParams();
            if (spec == null) {
                throw new InvalidKeyException("Key has null parameter spec");
            }
            return spec.getOrder().bitLength();
        }
        throw new InvalidKeyException("Not an Elliptic Curve Key");
    }

    @Override
    public int getKeySize(PrivateKey key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            ECParameterSpec spec = ((ECPrivateKey)key).getParams();
            if (spec == null) {
                throw new InvalidKeyException("Key has null parameter spec");
            }
            return spec.getOrder().bitLength();
        }
        throw new InvalidKeyException("Not an Elliptic Curve Key");
    }
}

