/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import org.symphonyoss.s2.common.crypto.cipher.SymmetricCipher;

class GenericCipherText {
    private final byte[] iv;
    private final byte[] authData;
    private final byte[] cipherText;

    public GenericCipherText(SymmetricCipher id, Cipher cipher, byte[] cipherData) throws GeneralSecurityException {
        if (cipherData == null) {
            throw new GeneralSecurityException("cipherText cannot be null");
        }
        int index = 0;
        switch (id) {
            case AES256_GCM: {
                this.iv = new byte[cipher.getBlockSize()];
                System.arraycopy(cipherData, index, this.iv, 0, this.iv.length);
                this.authData = new byte[cipher.getBlockSize()];
                System.arraycopy(cipherData, index += this.iv.length, this.authData, 0, this.authData.length);
                index += this.authData.length;
                break;
            }
            default: {
                this.authData = null;
                this.iv = new byte[cipher.getBlockSize()];
                System.arraycopy(cipherData, index, this.iv, 0, this.iv.length);
                index += this.iv.length;
            }
        }
        int ciphertextLength = cipherData.length - index;
        if (ciphertextLength <= 0) {
            throw new GeneralSecurityException("cipherText cannot be empty");
        }
        this.cipherText = new byte[ciphertextLength];
        System.arraycopy(cipherData, index, this.cipherText, 0, ciphertextLength);
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getAuthData() {
        return this.authData;
    }

    public byte[] getCipherText() {
        return this.cipherText;
    }
}

