/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.symphonyoss.s2.common.crypto.cipher.AsymmetricCipher;
import org.symphonyoss.s2.common.crypto.cipher.CertType;
import org.symphonyoss.s2.common.crypto.cipher.ICipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.ISymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.SignatureVerificationException;

public interface IAsymmetricCipherSuite
extends ICipherSuite {
    public AsymmetricCipher getId();

    public void validateKey(KeyPair var1) throws InvalidKeyException;

    public void validateKey(PrivateKey var1) throws InvalidKeyException;

    public void validateKey(PublicKey var1) throws InvalidKeyException;

    public String getSignatureAlgorithm();

    public PKCS10CertificationRequest createCSR(X500Name var1, PublicKey var2, PrivateKey var3, GeneralName[] var4) throws OperatorCreationException, IOException;

    public KeyPair generateKeyPair();

    public X509Certificate createSelfSignedCert(KeyPair var1, X500Name var2, int var3) throws InvalidKeyException;

    public byte[] sign(byte[] var1, PrivateKey var2) throws InvalidKeyException;

    public String sign(String var1, PrivateKey var2) throws InvalidKeyException;

    public void verifySignature(byte[] var1, byte[] var2, Certificate var3) throws SignatureVerificationException;

    public void verifySignature(byte[] var1, byte[] var2, PublicKey var3) throws SignatureVerificationException;

    public X509Certificate createMasterCert(PublicKey var1, PrivateKey var2, X500Name var3, Date var4, Date var5, URL var6, BigInteger var7);

    public X509Certificate createCert(String var1, PublicKey var2, X500Name var3, Date var4, Date var5, URL var6, PrivateKey var7, X509Certificate var8, BigInteger var9, String var10, URL var11, CertType var12) throws InvalidKeyException;

    public X509Certificate createCert(GeneralName[] var1, PublicKey var2, X500Name var3, Date var4, Date var5, URL var6, PrivateKey var7, X509Certificate var8, BigInteger var9, String var10, URL var11, CertType var12) throws InvalidKeyException;

    public X509Certificate createCert(GeneralName[] var1, PKCS10CertificationRequest var2, X500Name var3, Date var4, Date var5, URL var6, PrivateKey var7, X509Certificate var8, BigInteger var9, String var10, URL var11, CertType var12) throws InvalidKeyException, SignatureVerificationException;

    public X509AttributeCertificateHolder createAttributeCert(X509Certificate var1, Date var2, Date var3, URL var4, PrivateKey var5, X509Certificate var6, BigInteger var7, String var8, URL var9, String var10, String var11);

    public byte[] wrap(SecretKey var1, PublicKey var2) throws GeneralSecurityException;

    public SecretKey unwrap(byte[] var1, PrivateKey var2, ISymmetricCipherSuite var3) throws GeneralSecurityException;

    public String publicKeyToDER(PublicKey var1) throws IOException, GeneralSecurityException;

    public PublicKey publicKeyFromDER(String var1) throws IOException, GeneralSecurityException;

    public String privateKeyToDER(PrivateKey var1) throws IOException, GeneralSecurityException;

    public PrivateKey privateKeyFromDER(String var1) throws IOException, GeneralSecurityException;

    public int getKeySize(PublicKey var1) throws InvalidKeyException;

    public int getKeySize(PrivateKey var1) throws InvalidKeyException;
}

