/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.operator.OperatorCreationException;
import org.symphonyoss.s2.common.crypto.cipher.AbstractAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.AsymmetricCipher;
import org.symphonyoss.s2.common.crypto.cipher.IAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.ISymmetricCipherSuite;

class Ecc521CipherSuite
extends AbstractAsymmetricCipherSuite
implements IAsymmetricCipherSuite {
    private static final String KEY_ALGORITHM = "EC";
    private static final String SIGNATURE_ALGORITHM = "SHA512withECDSA";
    private static final String PROVIDER = "BC";
    private static final String CURVE_NAME = "secp521r1";
    private static final String WRAPPING_CIPHER_SPEC = "ECIESwithAES";
    private ECGenParameterSpec ecGenSpec;
    private KeyPairGenerator keyGen_;
    private SecureRandom rand_ = new SecureRandom();

    public Ecc521CipherSuite(AsymmetricCipher id) throws NoSuchAlgorithmException, NoSuchProviderException, OperatorCreationException, InvalidAlgorithmParameterException {
        super(id);
        this.ecGenSpec = new ECGenParameterSpec(CURVE_NAME);
        this.keyGen_ = KeyPairGenerator.getInstance(KEY_ALGORITHM, PROVIDER);
        this.keyGen_.initialize(this.ecGenSpec, this.rand_);
    }

    @Override
    public String getKeyAlgorithm() {
        return KEY_ALGORITHM;
    }

    @Override
    public Cipher getCipher() throws GeneralSecurityException {
        return Cipher.getInstance(WRAPPING_CIPHER_SPEC, PROVIDER);
    }

    @Override
    public int getKeySize() {
        return 521;
    }

    @Override
    public KeyPair generateKeyPair() {
        return this.keyGen_.generateKeyPair();
    }

    @Override
    public byte[] wrap(SecretKey key, PublicKey userKey) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        cipher.init(1, (Key)userKey, this.rand_);
        return cipher.doFinal(key.getEncoded());
    }

    @Override
    public SecretKey unwrap(byte[] cipherText, PrivateKey userPrivateKey, ISymmetricCipherSuite symmetricCipherSuite) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        cipher.init(2, (Key)userPrivateKey, this.rand_);
        byte[] encoded = cipher.doFinal(cipherText);
        return new SecretKeySpec(encoded, symmetricCipherSuite.getKeyAlgorithm());
    }

    @Override
    public String getSignatureAlgorithm() {
        return SIGNATURE_ALGORITHM;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PublicKey publicKeyFromDER(String der) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public PrivateKey privateKeyFromDER(String der) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int getKeySize(PublicKey key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            ECParameterSpec spec = ((ECPublicKey)key).getParams();
            if (spec == null) {
                throw new InvalidKeyException("Key has null parameter spec");
            }
            return spec.getOrder().bitLength();
        }
        throw new InvalidKeyException("Not an Elliptic Curve Key");
    }

    @Override
    public int getKeySize(PrivateKey key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            ECParameterSpec spec = ((ECPrivateKey)key).getParams();
            if (spec == null) {
                throw new InvalidKeyException("Key has null parameter spec");
            }
            return spec.getOrder().bitLength();
        }
        throw new InvalidKeyException("Not an Elliptic Curve Key");
    }
}

