/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cert;

import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.symphonyoss.s2.common.crypto.cert.Certificate;
import org.symphonyoss.s2.common.crypto.cert.CertificateFactory;
import org.symphonyoss.s2.common.crypto.cert.ICertificate;
import org.symphonyoss.s2.common.crypto.cert.IIntermediateCertificate;
import org.symphonyoss.s2.common.crypto.cert.IOpenCertificate;
import org.symphonyoss.s2.common.crypto.cipher.CertType;
import org.symphonyoss.s2.common.fault.CodingFault;
import org.symphonyoss.s2.common.time.DateUtils;

public class CertificateBuilder {
    private final IIntermediateCertificate signingCert_;
    private X500NameStyle template_ = BCStyle.INSTANCE;
    private List<RDN> rdns_ = new ArrayList<RDN>();
    private Date notBefore_ = new Date();
    private Date notAfter_ = DateUtils.getDateOffsetMonths((Date)this.notBefore_, (int)12);
    private BigInteger serial_ = BigInteger.ONE;
    private String countryName_;
    private String stateName_;
    private String orgName_;
    private List<String> orgUnitNames_ = new ArrayList<String>();
    private String commonName_;
    private CertType certType_ = CertType.UserSigning;
    private KeyPair keyPair_;
    private URL ocspUrl_;

    public CertificateBuilder(IIntermediateCertificate signingCert) {
        this.signingCert_ = signingCert;
    }

    public CertificateBuilder(IIntermediateCertificate signingCert, CertificateBuilder other) {
        this.signingCert_ = signingCert;
        this.notBefore_ = other.notBefore_;
        this.notAfter_ = other.notAfter_;
        this.serial_ = other.serial_;
        this.countryName_ = other.countryName_;
        this.stateName_ = other.stateName_;
        this.orgName_ = other.orgName_;
        this.orgUnitNames_.addAll(other.orgUnitNames_);
        this.commonName_ = other.commonName_;
        this.certType_ = other.certType_;
        this.ocspUrl_ = other.ocspUrl_;
    }

    public CertificateBuilder withCertType(CertType certType) {
        this.certType_ = certType;
        return this;
    }

    public CertificateBuilder withNotBefore(Date notBefore) {
        this.notBefore_ = notBefore;
        return this;
    }

    public CertificateBuilder withNotAfter(Date notAfter) {
        this.notAfter_ = notAfter;
        return this;
    }

    public CertificateBuilder withValidityMonths(int months) {
        this.notAfter_ = DateUtils.getDateOffsetMonths((Date)this.notBefore_, (int)months);
        return this;
    }

    public CertificateBuilder withValidityDays(int days) {
        this.notAfter_ = DateUtils.getDateOffsetDays((Date)this.notBefore_, (int)days);
        return this;
    }

    public CertificateBuilder withSerial(BigInteger serial) {
        this.serial_ = serial;
        return this;
    }

    public CertificateBuilder withOrgName(String orgName) {
        this.orgName_ = orgName;
        return this;
    }

    public CertificateBuilder withCountryName(String countryName) {
        this.countryName_ = countryName;
        return this;
    }

    public CertificateBuilder withStateName(String stateName) {
        this.stateName_ = stateName;
        return this;
    }

    public CertificateBuilder withOrganizationName(String orgName) {
        this.orgName_ = orgName;
        return this;
    }

    public CertificateBuilder withOrgUnitName(String orgUnitName) {
        this.orgUnitNames_.clear();
        this.orgUnitNames_.add(orgUnitName);
        return this;
    }

    public CertificateBuilder addOrgUnitName(String orgUnitName) {
        this.orgUnitNames_.add(orgUnitName);
        return this;
    }

    public CertificateBuilder withCommonName(String commonName) {
        this.commonName_ = commonName;
        return this;
    }

    public CertificateBuilder withOcspUrl(URL ocspUrl) {
        this.ocspUrl_ = ocspUrl;
        return this;
    }

    public CertificateBuilder withKeyPair(KeyPair keyPair) throws InvalidKeyException {
        this.signingCert_.getAsymmetricCipherSuite().validateKey(keyPair);
        this.keyPair_ = keyPair;
        return this;
    }

    private X500Name buildX500Name() {
        this.rdns_.clear();
        if (this.countryName_ != null) {
            this.addRDN(BCStyle.C, this.countryName_);
        }
        if (this.stateName_ != null) {
            this.addRDN(BCStyle.ST, this.stateName_);
        }
        if (this.orgName_ != null) {
            this.addRDN(BCStyle.O, this.orgName_);
        }
        for (String s : this.orgUnitNames_) {
            this.addRDN(BCStyle.OU, s);
        }
        if (this.commonName_ != null) {
            this.addRDN(BCStyle.CN, this.commonName_);
        }
        if (this.rdns_.isEmpty()) {
            this.addRDN(BCStyle.CN, "No Name");
        }
        RDN[] vals = this.rdns_.toArray(new RDN[this.rdns_.size()]);
        return new X500Name(this.template_, vals);
    }

    private CertificateBuilder addRDN(ASN1ObjectIdentifier oid, String value) {
        return this.addRDN(oid, this.template_.stringToValue(oid, value));
    }

    private CertificateBuilder addRDN(ASN1ObjectIdentifier oid, ASN1Encodable value) {
        this.rdns_.add(new RDN(oid, value));
        return this;
    }

    public Date getNotBefore() {
        return this.notBefore_;
    }

    public Date getNotAfter() {
        return this.notAfter_;
    }

    public BigInteger getSerial() {
        return this.serial_;
    }

    public String getCountryName() {
        return this.countryName_;
    }

    public String getStateName() {
        return this.stateName_;
    }

    public String getOrgName() {
        return this.orgName_;
    }

    public List<String> getOrgUnitNames() {
        return this.orgUnitNames_;
    }

    public String getCommonName() {
        return this.commonName_;
    }

    public CertType getCertType() {
        return this.certType_;
    }

    public KeyPair getKeyPair() {
        return this.keyPair_;
    }

    public URL getOcspUrl() {
        return this.ocspUrl_;
    }

    public IOpenCertificate build() {
        if (this.keyPair_ == null) {
            this.keyPair_ = this.signingCert_.getAsymmetricCipherSuite().generateKeyPair();
        }
        X500Name principal = this.buildX500Name();
        GeneralName[] subjectAlternativeNames = null;
        List<X509Certificate> signerCerts = this.signingCert_.getX509CertificateChain();
        X509Certificate[] certs = new X509Certificate[1 + signerCerts.size()];
        for (int index = 0; index < signerCerts.size(); ++index) {
            certs[index + 1] = signerCerts.get(index);
        }
        try {
            certs[0] = this.signingCert_.getAsymmetricCipherSuite().createCert(subjectAlternativeNames, this.keyPair_.getPublic(), principal, this.notBefore_, this.notAfter_, this.ocspUrl_, this.signingCert_.getPrivateKey(), this.signingCert_.getX509Certificate(), this.serial_, null, null, this.certType_);
        }
        catch (InvalidKeyException e) {
            throw new CodingFault((Throwable)e);
        }
        ICertificate result = CertificateFactory.typedCertificate(new Certificate(this.signingCert_.getAsymmetricCipherSuite(), certs, this.keyPair_));
        this.keyPair_ = null;
        this.serial_ = this.serial_.add(BigInteger.ONE);
        return (IOpenCertificate)result;
    }
}

