/*
 * Copyright 2016-2017  Symphony Communication Services, LLC.
 * 
 * Includes public domain material developed by Immutify Limited.
 *
 * Licensed to The Symphony Software Foundation (SSF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The SSF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.symphonyoss.s2.common.crypto.cipher;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

/**
 * The super-interface of symmetric and public key CipherSuites.
 * 
 * @author Bruce Skingle
 *
 */
public interface ICipherSuite
{
  /**
   * Return the name of the KeyAlgorithm used by this CipherSuite.
   * @return The name of the KeyAlgorithm used by this CipherSuite.
   */
	String getKeyAlgorithm();

	Cipher getCipher() throws GeneralSecurityException;

	/**
	 * 
	 * @return The size of the keys used by this CipherSuite, in bits.
	 */
	int getKeySize();
}
