/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.operator.OperatorCreationException;
import org.symphonyoss.s2.common.crypto.cipher.AbstractAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.AsymmetricCipher;
import org.symphonyoss.s2.common.crypto.cipher.IAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.ISymmetricCipherSuite;

class RsaCipherSuite
extends AbstractAsymmetricCipherSuite
implements IAsymmetricCipherSuite {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA256WithRSA";
    private static final String PROVIDER = "BC";
    private static final String WRAPPING_CIPHER_SPEC = "RSA/NONE/OAEPWithSHA256AndMGF1Padding";
    private int keySize_;
    private KeyPairGenerator keyGen_ = KeyPairGenerator.getInstance("RSA", "BC");
    private SecureRandom rand_ = new SecureRandom();

    public RsaCipherSuite(AsymmetricCipher id, int keySize) throws NoSuchAlgorithmException, NoSuchProviderException, OperatorCreationException {
        super(id);
        this.keySize_ = keySize;
        this.keyGen_.initialize(this.getKeySize(), this.rand_);
    }

    @Override
    public String getSignatureAlgorithm() {
        return SIGNATURE_ALGORITHM;
    }

    @Override
    public int getKeySize() {
        return this.keySize_;
    }

    @Override
    public String getKeyAlgorithm() {
        return KEY_ALGORITHM;
    }

    @Override
    public Cipher getCipher() throws GeneralSecurityException {
        return Cipher.getInstance(WRAPPING_CIPHER_SPEC, PROVIDER);
    }

    @Override
    public KeyPair generateKeyPair() {
        return this.keyGen_.generateKeyPair();
    }

    @Override
    public byte[] wrap(SecretKey key, PublicKey userKey) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        cipher.init(3, (Key)userKey, this.rand_);
        return cipher.wrap(key);
    }

    @Override
    public SecretKey unwrap(byte[] cipherText, PrivateKey userPrivateKey, ISymmetricCipherSuite symmetricCipherSuite) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        cipher.init(4, (Key)userPrivateKey, this.rand_);
        return (SecretKey)cipher.unwrap(cipherText, symmetricCipherSuite.getKeyAlgorithm(), 3);
    }

    @Override
    public int getKeySize(PublicKey key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return ((RSAPublicKey)key).getModulus().bitLength();
        }
        throw new InvalidKeyException("Not an RSA Key");
    }

    @Override
    public int getKeySize(PrivateKey key) throws InvalidKeyException {
        if (key instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)key).getModulus().bitLength();
        }
        throw new InvalidKeyException("Not an RSA Key");
    }
}

