/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.symphonyoss.s2.common.fault.CodingFault;
import org.symphonyoss.s2.common.fault.TransactionFault;

class CertificateUtils {
    private static JcaX509CertificateConverter x509Converter_ = new JcaX509CertificateConverter().setProvider("BC");

    CertificateUtils() {
    }

    public static String encode(X509Certificate[] x509CertificateChain) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(bos));){
                for (X509Certificate cert : x509CertificateChain) {
                    pemWriter.writeObject((Object)cert);
                }
            }
            return bos.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new TransactionFault("Failed to encode certificate", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<X509Certificate> decode(String certData) throws CertificateException {
        try (PEMParser pemReader = new PEMParser((Reader)new StringReader(certData));){
            JcaX509CertificateConverter jcaX509CertificateConverter;
            Object certificate;
            JcaX509CertificateConverter result = new ArrayList();
            while ((certificate = pemReader.readObject()) != null) {
                if (certificate instanceof X509Certificate) {
                    result.add((X509Certificate)((X509Certificate)certificate));
                    continue;
                }
                if (!(certificate instanceof X509CertificateHolder)) throw new CertificateException("Certificate decode resulted in " + certificate.getClass());
                jcaX509CertificateConverter = x509Converter_;
                synchronized (jcaX509CertificateConverter) {
                    result.add(x509Converter_.getCertificate((X509CertificateHolder)certificate));
                }
            }
            jcaX509CertificateConverter = result;
            return jcaX509CertificateConverter;
        }
        catch (IOException e) {
            throw new TransactionFault("Failed to decode certificate", (Throwable)e);
        }
    }

    public static String getCommonName(X500Principal principal) {
        Pattern p = Pattern.compile("(^|,)CN=([^,]*)(,|$)");
        Matcher m = p.matcher(principal.getName());
        m.find();
        try {
            return m.group(2);
        }
        catch (IllegalStateException e) {
            return principal.getName();
        }
    }

    public static String getFingerPrint(X509Certificate cert) throws CertificateEncodingException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return CertificateUtils.toHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CodingFault("Cannot get SHA-1", (Throwable)e);
        }
    }

    public static String toHex(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }
}

