/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.AttributeCertificateHolder;
import org.bouncycastle.cert.AttributeCertificateIssuer;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2AttributeCertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.symphonyoss.s2.common.crypto.cipher.AbstractCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.AsymmetricCipher;
import org.symphonyoss.s2.common.crypto.cipher.CertType;
import org.symphonyoss.s2.common.crypto.cipher.IAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.SignatureVerificationException;
import org.symphonyoss.s2.common.fault.CodingFault;
import org.symphonyoss.s2.common.fault.TransactionFault;

abstract class AbstractAsymmetricCipherSuite
extends AbstractCipherSuite
implements IAsymmetricCipherSuite {
    private static final String BC = "BC";
    private AlgorithmIdentifier sigAlgId_ = new DefaultSignatureAlgorithmIdentifierFinder().find(this.getSignatureAlgorithm());
    private AlgorithmIdentifier digAlgId_ = new DefaultDigestAlgorithmIdentifierFinder().find(this.sigAlgId_);
    private JcaX509CertificateConverter converter_ = new JcaX509CertificateConverter().setProvider("BC");
    private JcaX509ExtensionUtils extensionUtils_;
    private AsymmetricCipher id_;

    public AbstractAsymmetricCipherSuite(AsymmetricCipher id) {
        try {
            this.id_ = id;
            DigestCalculator digestCalculator = new JcaDigestCalculatorProviderBuilder().setProvider(BC).build().get(this.digAlgId_);
            this.extensionUtils_ = new JcaX509ExtensionUtils(digestCalculator);
        }
        catch (OperatorCreationException e) {
            throw new CodingFault((Throwable)e);
        }
    }

    @Override
    public AsymmetricCipher getId() {
        return this.id_;
    }

    @Override
    public X509Certificate createSelfSignedCert(KeyPair keyPair, X500Name subject, int validDays) throws InvalidKeyException {
        JcaX509v1CertificateBuilder builder = new JcaX509v1CertificateBuilder(subject, BigInteger.valueOf(1L), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 86400000L * (long)validDays), subject, keyPair.getPublic());
        this.validateKey(keyPair);
        try {
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.getSignatureAlgorithm()).setProvider(BC);
            ContentSigner signer = signerBuilder.build(keyPair.getPrivate());
            X509CertificateHolder holder = builder.build(signer);
            X509Certificate cert = this.converter_.getCertificate(holder);
            return cert;
        }
        catch (CertificateException | OperatorCreationException e) {
            throw new TransactionFault(e);
        }
    }

    @Override
    public PKCS10CertificationRequest createCSR(X500Name subject, PublicKey publicKey, PrivateKey privateKey, GeneralName[] subjectAlternateNames) throws OperatorCreationException, IOException {
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(subject, publicKeyInfo);
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.getSignatureAlgorithm()).setProvider(BC);
        ContentSigner signer = signerBuilder.build(privateKey);
        if (subjectAlternateNames != null) {
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(subjectAlternateNames));
            builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        }
        return builder.build(signer);
    }

    @Override
    public X509Certificate createCert(GeneralName[] subjectAlternativeNames, PKCS10CertificationRequest csr, X500Name principal, Date notBefore, Date notAfter, URL ocspUrl, PrivateKey caPrivKey, X509Certificate caCert, BigInteger serialNumber, String policyOid, URL policyUrl, CertType certificateType) throws InvalidKeyException, SignatureVerificationException {
        PublicKey publicKey;
        JcaPKCS10CertificationRequest csrHolder = new JcaPKCS10CertificationRequest(csr);
        try {
            publicKey = csrHolder.getPublicKey();
            if (!csrHolder.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(BC).build(publicKey))) {
                throw new SignatureVerificationException("CSR Signature is invalid");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | OperatorCreationException | PKCSException e) {
            throw new SignatureVerificationException("Unable to verify CSR Signature", e);
        }
        if (principal == null) {
            Attribute[] certAttributes;
            principal = csrHolder.getSubject();
            for (Attribute attribute : certAttributes = csrHolder.getAttributes()) {
                if (!attribute.getAttrType().equals((Object)PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) continue;
                Extensions extensions = Extensions.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
                GeneralNames gns = GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                subjectAlternativeNames = gns.getNames();
            }
        }
        return this.createCert(subjectAlternativeNames, publicKey, principal, notBefore, notAfter, ocspUrl, caPrivKey, caCert, serialNumber, policyOid, policyUrl, certificateType);
    }

    @Override
    public String sign(String data, PrivateKey privateKey) throws InvalidKeyException {
        byte[] sigBytes = this.sign(data.getBytes(StandardCharsets.UTF_8), privateKey);
        return new String(Base64.encode((byte[])sigBytes));
    }

    @Override
    public byte[] sign(byte[] data, PrivateKey privateKey) throws InvalidKeyException {
        try {
            Signature signature = Signature.getInstance(this.getSignatureAlgorithm());
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException | SignatureException e) {
            throw new TransactionFault((Throwable)e);
        }
    }

    @Override
    public void verifySignature(byte[] encodedSignature, byte[] data, Certificate certificate) throws SignatureVerificationException {
        try {
            Signature signature = Signature.getInstance(this.getSignatureAlgorithm());
            signature.initVerify(certificate);
            signature.update(data);
            if (!signature.verify(encodedSignature)) {
                throw new SignatureVerificationException("Signature verification failed");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureVerificationException("Signature verification failed", e);
        }
    }

    @Override
    public void verifySignature(byte[] encodedSignature, byte[] data, PublicKey publicKey) throws SignatureVerificationException {
        try {
            Signature signature = Signature.getInstance(this.getSignatureAlgorithm());
            signature.initVerify(publicKey);
            signature.update(data);
            if (!signature.verify(encodedSignature)) {
                throw new SignatureVerificationException("Signature verification failed");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureVerificationException("Signature verification failed", e);
        }
    }

    @Override
    public X509Certificate createMasterCert(PublicKey pubKey, PrivateKey privKey, X500Name principal, Date notBefore, Date notAfter, URL ocspUrl, BigInteger serialNumber) {
        try {
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(principal, serialNumber, notBefore, notAfter, principal, pubKey);
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.extensionUtils_.createSubjectKeyIdentifier(pubKey));
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(1));
            builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(6));
            if (ocspUrl != null) {
                GeneralName location = new GeneralName(6, ocspUrl.toString());
                AuthorityInformationAccess auth = new AuthorityInformationAccess(AccessDescription.id_ad_ocsp, location);
                builder.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)auth);
            }
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(this.getSignatureAlgorithm()).setProvider(BC);
            ContentSigner signer = signerBuilder.build(privKey);
            X509CertificateHolder holder = builder.build(signer);
            return this.converter_.getCertificate(holder);
        }
        catch (IOException | CertificateException | OperatorCreationException e) {
            throw new TransactionFault(e);
        }
    }

    @Override
    public X509Certificate createCert(String subjectRfc822AlternativeName, PublicKey pubKey, X500Name principal, Date notBefore, Date notAfter, URL ocspUrl, PrivateKey caPrivKey, X509Certificate caCert, BigInteger serialNumber, String policyOid, URL policyUrl, CertType certificateType) throws InvalidKeyException {
        GeneralName[] subjectAlternativeNames = null;
        if (subjectRfc822AlternativeName != null) {
            subjectAlternativeNames = new GeneralName[]{new GeneralName(1, (ASN1Encodable)new DERIA5String(subjectRfc822AlternativeName))};
        }
        return this.createCert(subjectAlternativeNames, pubKey, principal, notBefore, notAfter, ocspUrl, caPrivKey, caCert, serialNumber, policyOid, policyUrl, certificateType);
    }

    @Override
    public X509Certificate createCert(GeneralName[] subjectAlternativeNames, PublicKey pubKey, X500Name principal, Date notBefore, Date notAfter, URL ocspUrl, PrivateKey caPrivKey, X509Certificate caCert, BigInteger serialNumber, String policyOid, URL policyUrl, CertType certificateType) throws InvalidKeyException {
        this.validateKey(pubKey);
        this.validateKey(caPrivKey);
        try {
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(caCert, serialNumber, notBefore, notAfter, principal, pubKey);
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.extensionUtils_.createSubjectKeyIdentifier(pubKey));
            builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)this.extensionUtils_.createAuthorityKeyIdentifier(caCert));
            switch (certificateType) {
                case UserEncryption: {
                    builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(48));
                    builder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_emailProtection));
                    break;
                }
                case Node: 
                case UserSigning: {
                    builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(192));
                    builder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
                    break;
                }
                case Server: {
                    builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(176));
                    builder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
                    break;
                }
                case Intermediate: {
                    builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
                    builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(6));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Certificate Type " + certificateType.toString());
                }
            }
            if (subjectAlternativeNames != null) {
                builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(subjectAlternativeNames));
            }
            if (ocspUrl != null) {
                GeneralName location = new GeneralName(6, ocspUrl.toString());
                AuthorityInformationAccess auth = new AuthorityInformationAccess(AccessDescription.id_ad_ocsp, location);
                builder.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)auth);
            }
            if (policyOid != null && policyUrl != null) {
                ASN1ObjectIdentifier objectId = new ASN1ObjectIdentifier(policyOid);
                PolicyQualifierInfo policyQualifierInfo = new PolicyQualifierInfo(policyUrl.toString());
                DERSequence qualifiers = new DERSequence((ASN1Encodable)policyQualifierInfo);
                ASN1EncodableVector poliVec = new ASN1EncodableVector();
                poliVec.add((ASN1Encodable)objectId);
                poliVec.add((ASN1Encodable)qualifiers);
                DERSequence poliSequence = new DERSequence(poliVec);
                DERSequence certificatePolicies = new DERSequence((ASN1Encodable)poliSequence);
                builder.addExtension(Extension.certificatePolicies, false, (ASN1Encodable)certificatePolicies);
            }
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(caCert.getSigAlgName()).setProvider(BC);
            ContentSigner signer = signerBuilder.build(caPrivKey);
            X509CertificateHolder holder = builder.build(signer);
            return this.converter_.getCertificate(holder);
        }
        catch (IOException | CertificateException | OperatorCreationException e) {
            throw new TransactionFault(e);
        }
    }

    @Override
    public X509AttributeCertificateHolder createAttributeCert(X509Certificate clientCert, Date notBefore, Date notAfter, URL ocspUrl, PrivateKey caPrivKey, X509Certificate caCert, BigInteger serialNumber, String policyOid, URL policyUrl, String attributeId, String attributeValue) {
        try {
            X500Name clientName = X500Name.getInstance((Object)clientCert.getSubjectX500Principal().getEncoded());
            X500Name issuerName = X500Name.getInstance((Object)caCert.getSubjectX500Principal().getEncoded());
            X509v2AttributeCertificateBuilder builder = new X509v2AttributeCertificateBuilder(new AttributeCertificateHolder(clientName), new AttributeCertificateIssuer(issuerName), serialNumber, notBefore, notAfter);
            if (ocspUrl != null) {
                GeneralName location = new GeneralName(6, ocspUrl.toString());
                AuthorityInformationAccess auth = new AuthorityInformationAccess(AccessDescription.id_ad_ocsp, location);
                builder.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)auth);
            }
            if (policyOid != null && policyUrl != null) {
                ASN1ObjectIdentifier objectId = new ASN1ObjectIdentifier(policyOid);
                PolicyQualifierInfo policyQualifierInfo = new PolicyQualifierInfo(policyUrl.toString());
                DERSequence qualifiers = new DERSequence((ASN1Encodable)policyQualifierInfo);
                ASN1EncodableVector poliVec = new ASN1EncodableVector();
                poliVec.add((ASN1Encodable)objectId);
                poliVec.add((ASN1Encodable)qualifiers);
                DERSequence poliSequence = new DERSequence(poliVec);
                DERSequence certificatePolicies = new DERSequence((ASN1Encodable)poliSequence);
                builder.addExtension(Extension.certificatePolicies, false, (ASN1Encodable)certificatePolicies);
            }
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(attributeId));
            v.add((ASN1Encodable)new DERIA5String(attributeValue));
            GeneralName generalName = new GeneralName(0, (ASN1Encodable)new DERSequence(v));
            ASN1EncodableVector roleSyntax = new ASN1EncodableVector();
            roleSyntax.add((ASN1Encodable)generalName);
            builder.addAttribute(new ASN1ObjectIdentifier(attributeId), (ASN1Encodable)new DERSequence(roleSyntax));
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(caCert.getSigAlgName()).setProvider(BC);
            ContentSigner signer = signerBuilder.build(caPrivKey);
            return builder.build(signer);
        }
        catch (IOException | OperatorCreationException e) {
            throw new TransactionFault(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String publicKeyToDER(PublicKey key) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public PublicKey publicKeyFromDER(String der) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String privateKeyToDER(PrivateKey key) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public PrivateKey privateKeyFromDER(String der) throws IOException, GeneralSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void validateKey(KeyPair keyPair) throws InvalidKeyException {
        this.validateKey(keyPair.getPublic());
    }

    @Override
    public void validateKey(PrivateKey key) throws InvalidKeyException {
        if (this.getKeySize(key) != this.getKeySize()) {
            throw new InvalidKeyException("Incorrect key size");
        }
    }

    @Override
    public void validateKey(PublicKey key) throws InvalidKeyException {
        if (this.getKeySize(key) != this.getKeySize()) {
            throw new InvalidKeyException("Incorrect key size");
        }
    }
}

