/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.symphonyoss.s2.common.fault.CodingFault;
import org.symphonyoss.s2.common.type.IPersistentEnum;
import org.symphonyoss.s2.common.type.InvalidPersistentEnumException;

public enum SymmetricCipher implements IPersistentEnum
{
    AES256_GCM(0),
    AES128_CBC(1),
    AES192_CBC(2),
    AES256_CBC(3);

    private static Map<Integer, SymmetricCipher> idMap_;
    private final int id_;

    private SymmetricCipher(int id) {
        this.id_ = id;
    }

    public int toInt() {
        return this.id_;
    }

    @Nonnull
    public static SymmetricCipher newInstance(int id) throws InvalidPersistentEnumException {
        SymmetricCipher v = idMap_.get(id);
        if (v == null) {
            throw new InvalidPersistentEnumException("Invalid SymmetricCipher ID " + id);
        }
        return v;
    }

    static {
        idMap_ = new HashMap<Integer, SymmetricCipher>();
        for (SymmetricCipher v : SymmetricCipher.values()) {
            if (idMap_.containsKey(v.toInt())) {
                throw new CodingFault("Duplicate id " + v.toInt());
            }
            idMap_.put(v.toInt(), v);
        }
    }
}

