/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cert;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.symphonyoss.s2.common.crypto.cert.CertificateBuilder;
import org.symphonyoss.s2.common.crypto.cert.CertificateUtils;
import org.symphonyoss.s2.common.crypto.cert.ICertificate;
import org.symphonyoss.s2.common.crypto.cert.IIntermediateCertificate;
import org.symphonyoss.s2.common.crypto.cert.IOpenCertificate;
import org.symphonyoss.s2.common.crypto.cert.ISigningCertificate;
import org.symphonyoss.s2.common.crypto.cipher.CertType;
import org.symphonyoss.s2.common.crypto.cipher.CipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.IAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.SignatureVerificationException;
import org.symphonyoss.s2.common.crypto.cipher.UnknownCipherSuiteException;

@Immutable
class Certificate
implements ICertificate {
    private static final String PKCS12 = "PKCS12";
    private static final String DEFAULT_ALIAS = "1";
    private final IAsymmetricCipherSuite asymmetricCipherSuite_;
    private final X509Certificate x509Certificate_;
    private final List<X509Certificate> x509CertificateChain_;
    private final PublicKey publicKey_;
    private final PrivateKey privateKey_;

    Certificate(IAsymmetricCipherSuite asymmetricCipherSuite, X509Certificate x509Certificate, List<X509Certificate> x509CertificateChain, PublicKey publicKey, PrivateKey privateKey) {
        this.asymmetricCipherSuite_ = asymmetricCipherSuite;
        this.x509Certificate_ = x509Certificate;
        this.x509CertificateChain_ = x509CertificateChain;
        this.publicKey_ = publicKey;
        this.privateKey_ = privateKey;
    }

    Certificate(IAsymmetricCipherSuite asymmetricCipherSuite, X509Certificate[] certs, KeyPair keyPair) {
        this.asymmetricCipherSuite_ = asymmetricCipherSuite;
        this.x509Certificate_ = certs[0];
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>(certs.length);
        for (X509Certificate cert : certs) {
            certChain.add(cert);
        }
        this.x509CertificateChain_ = Collections.unmodifiableList(certChain);
        this.publicKey_ = keyPair.getPublic();
        this.privateKey_ = keyPair.getPrivate();
    }

    Certificate(String certChain) throws UnknownCipherSuiteException, CertificateException {
        if (certChain.isEmpty()) {
            throw new CertificateException("Cert chain is empty");
        }
        this.x509CertificateChain_ = Collections.unmodifiableList(CertificateUtils.decode(certChain));
        this.x509Certificate_ = this.x509CertificateChain_.get(0);
        this.publicKey_ = this.x509Certificate_.getPublicKey();
        this.asymmetricCipherSuite_ = CipherSuite.get(this.publicKey_);
        this.privateKey_ = null;
    }

    Certificate(Certificate other) {
        this.asymmetricCipherSuite_ = other.asymmetricCipherSuite_;
        this.x509Certificate_ = other.x509Certificate_;
        this.x509CertificateChain_ = other.x509CertificateChain_;
        this.publicKey_ = other.publicKey_;
        this.privateKey_ = other.privateKey_;
    }

    Certificate(String certChain, String encryptedKey, @Nullable char[] passPhrase) throws CertificateException, UnknownCipherSuiteException {
        if (certChain.isEmpty()) {
            throw new CertificateException("Cert chain is empty");
        }
        this.x509CertificateChain_ = Collections.unmodifiableList(CertificateUtils.decode(certChain));
        this.x509Certificate_ = this.x509CertificateChain_.get(0);
        this.publicKey_ = this.x509Certificate_.getPublicKey();
        this.asymmetricCipherSuite_ = CipherSuite.get(this.publicKey_);
        try (PEMParser pemReader = new PEMParser((Reader)new StringReader(encryptedKey));){
            KeyPair kp;
            Object object = pemReader.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof PEMEncryptedKeyPair) {
                if (passPhrase == null) {
                    throw new CertificateException("Key is encrypted and passPhrase is null");
                }
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(passPhrase);
                kp = converter.getKeyPair(ckp.decryptKeyPair(decProv));
            } else if (object instanceof PEMKeyPair) {
                PEMKeyPair ukp = (PEMKeyPair)object;
                kp = converter.getKeyPair(ukp);
            } else {
                if (object == null) {
                    throw new CertificateException("Unable to read private key.");
                }
                throw new CertificateException("Unable to read private key, read a " + object.getClass());
            }
            if (!kp.getPublic().equals(this.getPublicKey())) {
                throw new CertificateException("KeyPair does not match public key in given certificate.");
            }
            this.privateKey_ = kp.getPrivate();
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    Certificate(X509Certificate[] certChain, PrivateKey privateKey) throws CertificateException, UnknownCipherSuiteException {
        if (certChain.length == 0) {
            throw new CertificateException("Cert chain is empty");
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(certChain.length);
        for (X509Certificate c : certChain) {
            certList.add(c);
        }
        this.x509CertificateChain_ = Collections.unmodifiableList(certList);
        this.x509Certificate_ = this.x509CertificateChain_.get(0);
        this.publicKey_ = this.x509Certificate_.getPublicKey();
        this.asymmetricCipherSuite_ = CipherSuite.get(this.publicKey_);
        this.privateKey_ = privateKey;
    }

    public IIntermediateCertificate createIntermediateCert(CertificateBuilder builder) throws CertificateException {
        IOpenCertificate cert = builder.withCertType(CertType.Intermediate).build();
        return (IIntermediateCertificate)cert;
    }

    public ISigningCertificate createUserSigningCert(CertificateBuilder builder) throws CertificateException {
        IOpenCertificate cert = builder.withCertType(CertType.UserSigning).build();
        return (ISigningCertificate)cert;
    }

    @Override
    public List<X509Certificate> getX509CertificateChain() {
        return this.x509CertificateChain_;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey_;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey_;
    }

    @Override
    public X509Certificate getX509Certificate() {
        return this.x509Certificate_;
    }

    public byte[] sign(byte[] data) throws GeneralSecurityException {
        return this.getAsymmetricCipherSuite().sign(data, this.privateKey_);
    }

    public void verifySignature(ByteString signature, byte[] payload) throws SignatureVerificationException {
        this.verifySignature(signature.toByteArray(), payload);
    }

    public void verifySignature(byte[] signature, byte[] payload) throws SignatureVerificationException {
        this.getAsymmetricCipherSuite().verifySignature(signature, payload, this.getPublicKey());
    }

    @Override
    public IAsymmetricCipherSuite getAsymmetricCipherSuite() {
        return this.asymmetricCipherSuite_;
    }

    public void storeUserKeystore(File file, char[] password) throws IOException, GeneralSecurityException {
        this.store(file, PKCS12, DEFAULT_ALIAS, password);
    }

    public void store(File file, String storeType, String alias, char[] password) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(storeType);
        keyStore.load(null);
        if (this.privateKey_ == null) {
            keyStore.setCertificateEntry(alias, this.x509Certificate_);
        } else {
            keyStore.setKeyEntry(alias, this.privateKey_, password, this.x509CertificateChain_.toArray(new X509Certificate[this.x509CertificateChain_.size()]));
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            keyStore.store(out, password);
        }
    }
}

