/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.bouncycastle.util.Arrays;
import org.symphonyoss.s2.common.crypto.cipher.AesCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.GenericCipherText;
import org.symphonyoss.s2.common.crypto.cipher.SymmetricCipher;

class Aes256GCMCipherSuite
extends AesCipherSuite {
    public Aes256GCMCipherSuite(SymmetricCipher id) throws NoSuchAlgorithmException, NoSuchProviderException {
        super(id, "AES/GCM/NoPadding", 256);
    }

    @Override
    public byte[] encrypt(SecretKey secretKey, byte[] data) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        byte[] iv = new byte[cipher.getBlockSize()];
        this.rand_.nextBytes(iv);
        GCMParameterSpec spec = new GCMParameterSpec(cipher.getBlockSize() * 8, iv);
        cipher.init(1, (Key)secretKey, spec);
        byte[] authData = new byte[cipher.getBlockSize()];
        this.rand_.nextBytes(authData);
        cipher.updateAAD(authData);
        byte[] encryptedData = cipher.doFinal(data);
        byte[] cipherText = Arrays.concatenate((byte[])iv, (byte[])authData);
        cipherText = Arrays.concatenate((byte[])cipherText, (byte[])encryptedData);
        return cipherText;
    }

    @Override
    public byte[] decrypt(SecretKey key, byte[] cipherText) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        GenericCipherText genericCipherText = new GenericCipherText(this.getId(), cipher, cipherText);
        GCMParameterSpec spec = new GCMParameterSpec(cipher.getBlockSize() * 8, genericCipherText.getIv());
        cipher.init(2, (Key)key, spec);
        cipher.updateAAD(genericCipherText.getAuthData());
        byte[] clearText = cipher.doFinal(genericCipherText.getCipherText());
        return clearText;
    }
}

