/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.util.Arrays;
import org.symphonyoss.s2.common.crypto.cipher.AbstractDecryptedInputStream;
import org.symphonyoss.s2.common.crypto.cipher.AbstractEncryptedOutputStream;
import org.symphonyoss.s2.common.crypto.cipher.AbstractSymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.GenericCipherText;
import org.symphonyoss.s2.common.crypto.cipher.IAsymmetricCipherSuite;
import org.symphonyoss.s2.common.crypto.cipher.SymmetricCipher;

class AesCipherSuite
extends AbstractSymmetricCipherSuite {
    private static final String KEY_ALGORITHM = "AES";
    private static final String PROVIDER = "BC";
    protected static final String AES_CBC_PKCS7Padding_CIPHER = "AES/CBC/PKCS7Padding";
    protected static final String AES_GCM_NoPadding_CIPHER = "AES/GCM/NoPadding";
    private String cipher_;
    private int keySize_;
    private KeyGenerator keyGen_;
    protected SecureRandom rand_ = new SecureRandom();

    public AesCipherSuite(SymmetricCipher id, String cipherMode, int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        super(id);
        this.cipher_ = cipherMode;
        this.keySize_ = keySize;
        this.keyGen_ = KeyGenerator.getInstance(KEY_ALGORITHM, PROVIDER);
        this.keyGen_.init(this.keySize_, this.rand_);
    }

    @Override
    public String getKeyAlgorithm() {
        return KEY_ALGORITHM;
    }

    @Override
    public int getKeySize() {
        return this.keySize_;
    }

    @Override
    public Cipher getCipher() throws GeneralSecurityException {
        return Cipher.getInstance(this.cipher_, PROVIDER);
    }

    @Override
    public SecretKey generateKey() {
        return this.keyGen_.generateKey();
    }

    @Override
    public byte[] encrypt(SecretKey secretKey, byte[] data) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        byte[] iv = new byte[cipher.getBlockSize()];
        this.rand_.nextBytes(iv);
        cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
        byte[] encryptedData = cipher.doFinal(data);
        byte[] cipherText = Arrays.concatenate((byte[])iv, (byte[])encryptedData);
        return cipherText;
    }

    @Override
    public byte[] decrypt(SecretKey secretKey, byte[] cipherText) throws GeneralSecurityException {
        try {
            Cipher cipher = this.getCipher();
            GenericCipherText genericCipherText = new GenericCipherText(this.getId(), cipher, cipherText);
            byte[] iv = genericCipherText.getIv();
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            byte[] clearText = cipher.doFinal(genericCipherText.getCipherText());
            return clearText;
        }
        catch (Exception e) {
            throw new GeneralSecurityException("decryption failed: " + e.getMessage());
        }
    }

    @Override
    public EncryptedOutputStream createEncryptedOutputStream(SecretKey key) throws IOException {
        if (key == null) {
            throw new IOException("Null Key");
        }
        return new EncryptedOutputStream(key, new ByteArrayOutputStream());
    }

    @Override
    public DecryptedInputStream createDecryptedInputStream(SecretKey key, byte[] encryptedData) throws GeneralSecurityException, IOException {
        if (key == null) {
            throw new IOException("Null Key");
        }
        if (encryptedData == null) {
            throw new IOException("Null CipherText");
        }
        byte[] rData = this.decrypt(key, encryptedData);
        ByteArrayInputStream bin = new ByteArrayInputStream(rData);
        return new DecryptedInputStream(bin);
    }

    @Override
    public byte[] wrap(PrivateKey key, SecretKey userKey) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        cipher.init(3, (Key)userKey, this.rand_);
        return cipher.wrap(key);
    }

    @Override
    public PrivateKey unwrap(byte[] cipherText, SecretKey userKey, IAsymmetricCipherSuite cipherSuite) throws GeneralSecurityException {
        Cipher cipher = this.getCipher();
        cipher.init(4, (Key)userKey, this.rand_);
        return (PrivateKey)cipher.unwrap(cipherText, cipherSuite.getKeyAlgorithm(), 2);
    }

    @Override
    public int getKeySize(SecretKey key) {
        return key.getEncoded().length * 8;
    }

    public class DecryptedInputStream
    extends AbstractDecryptedInputStream {
        private ByteArrayInputStream bin_;

        private DecryptedInputStream(ByteArrayInputStream bin) throws IOException {
            super(bin);
            this.bin_ = bin;
        }

        @Override
        public void close() throws IOException {
            this.bin_.close();
            super.close();
        }
    }

    public class EncryptedOutputStream
    extends AbstractEncryptedOutputStream {
        private SecretKey key_;
        private ByteArrayOutputStream bout_;

        private EncryptedOutputStream(SecretKey key, ByteArrayOutputStream bout) throws IOException {
            super(bout);
            this.key_ = key;
            this.bout_ = bout;
        }

        @Override
        public byte[] getCipherText() throws GeneralSecurityException {
            return AesCipherSuite.this.encrypt(this.key_, this.bout_.toByteArray());
        }

        @Override
        public void close() throws IOException {
            this.bout_.close();
            super.close();
        }
    }
}

