/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.common.crypto.cipher;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.symphonyoss.s2.common.fault.CodingFault;
import org.symphonyoss.s2.common.type.IPersistentEnum;
import org.symphonyoss.s2.common.type.InvalidPersistentEnumException;

public enum AsymmetricCipher implements IPersistentEnum
{
    RSA2048(0),
    RSA1024(1),
    ECC521(2);

    private static Map<Integer, AsymmetricCipher> idMap_;
    private final int id_;

    private AsymmetricCipher(int id) {
        this.id_ = id;
    }

    public int toInt() {
        return this.id_;
    }

    @Nonnull
    public static AsymmetricCipher newInstance(int id) throws InvalidPersistentEnumException {
        AsymmetricCipher v = idMap_.get(id);
        if (v == null) {
            throw new InvalidPersistentEnumException("Invalid AsymmetricCipher ID " + id);
        }
        return v;
    }

    static {
        idMap_ = new HashMap<Integer, AsymmetricCipher>();
        for (AsymmetricCipher v : AsymmetricCipher.values()) {
            if (idMap_.containsKey(v.toInt())) {
                throw new CodingFault("Duplicate id " + v.toInt());
            }
            idMap_.put(v.toInt(), v);
        }
    }
}

