/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.di.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.symphonyoss.s2.fugue.di.Cardinality;
import org.symphonyoss.s2.fugue.di.IBinder;
import org.symphonyoss.s2.fugue.di.impl.Dependency;

public class ComponentDescriptor {
    private List<Dependency<?>> dependencyList_ = new ArrayList();
    private Set<Class<?>> providedInterfaces_ = new HashSet();
    private List<Runnable> startHandlers_ = new ArrayList<Runnable>();
    private List<Runnable> stopHandlers_ = new ArrayList<Runnable>();

    public <T> ComponentDescriptor addDependency(Class<T> requiredInterface, IBinder<T> binder) {
        return this.addDependency(requiredInterface, binder, Cardinality.one);
    }

    public <T> ComponentDescriptor addDependency(Class<T> requiredInterface, IBinder<T> binder, Cardinality cardinality) {
        this.dependencyList_.add(new Dependency<T>(requiredInterface, binder, cardinality));
        return this;
    }

    public ComponentDescriptor addProvidedInterface(Class<?> providedInterface) {
        this.providedInterfaces_.add(providedInterface);
        return this;
    }

    public ComponentDescriptor addStart(Runnable handler) {
        this.startHandlers_.add(handler);
        return this;
    }

    public ComponentDescriptor addStop(Runnable handler) {
        this.stopHandlers_.add(handler);
        return this;
    }

    public List<Dependency<?>> getDependencies() {
        return this.dependencyList_;
    }

    public Set<Class<?>> getProvidedInterfaces() {
        return this.providedInterfaces_;
    }

    public List<Runnable> getStartHandlers() {
        return this.startHandlers_;
    }

    public List<Runnable> getStopHandlers() {
        return this.stopHandlers_;
    }

    public ComponentDescriptor removeProvidedInterface(Class<?> providedInterface) {
        this.providedInterfaces_.remove(providedInterface);
        return this;
    }
}

