/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.di.impl;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.symphonyoss.s2.fugue.di.ConfigurationError;
import org.symphonyoss.s2.fugue.di.DIContextState;
import org.symphonyoss.s2.fugue.di.IComponent;
import org.symphonyoss.s2.fugue.di.IComponentProvider;
import org.symphonyoss.s2.fugue.di.IDIContext;
import org.symphonyoss.s2.fugue.di.component.ILogComponent;
import org.symphonyoss.s2.fugue.di.component.impl.DefaultLogComponent;
import org.symphonyoss.s2.fugue.di.impl.ComponentDescriptor;
import org.symphonyoss.s2.fugue.di.impl.ComponentHolder;
import org.symphonyoss.s2.fugue.di.impl.Dependency;

public class DIContext
implements IDIContext {
    private static final String UNREACHABLE_CODE = "UNREACHABLE CODE - or did you change Cardinality?";
    private ILogComponent log_ = new DefaultLogComponent();
    private Map<Class<?>, List<ComponentHolder>> providedInterfaceMap_ = new HashMap();
    private List<ComponentHolder> componentList_ = new ArrayList<ComponentHolder>();
    private Object lifeCycleLock_ = new Object();
    private DIContextState lifeCycle_ = DIContextState.Initializing;
    private List<IComponent> unresolvableComponentList_ = new ArrayList<IComponent>();
    private boolean logProvided_;
    private Stack<ComponentHolder> stopStack_ = new Stack();

    @Override
    public synchronized DIContext register(IComponent component) {
        if (this.getLifeCycle() != DIContextState.Initializing) {
            throw new IllegalStateException("Components cannot be added once resolution has started");
        }
        ComponentHolder holder = new ComponentHolder(component);
        ComponentDescriptor desc = holder.getComponentDescriptor();
        for (Class<?> providedInterface : desc.getProvidedInterfaces()) {
            if (!providedInterface.isInstance(component)) {
                throw new InvalidParameterException("Component " + component.getClass() + " does not implement the interface " + providedInterface + " which it declares to provide.");
            }
            List<ComponentHolder> list = this.providedInterfaceMap_.get(providedInterface);
            if (list == null) {
                list = new ArrayList<ComponentHolder>();
                this.providedInterfaceMap_.put(providedInterface, list);
            }
            list.add(holder);
            if (providedInterface != ILogComponent.class) continue;
            this.log_ = (ILogComponent)component;
            this.logProvided_ = true;
        }
        this.componentList_.add(holder);
        if (component instanceof IComponentProvider) {
            ((IComponentProvider)((Object)component)).registerComponents(this);
        }
        return this;
    }

    @Override
    public void resolveAndStart() {
        this.resolve(true);
    }

    @Override
    public void resolve() {
        this.resolve(false);
    }

    private synchronized void resolve(boolean start) {
        if (!this.logProvided_) {
            this.register(this.log_);
        }
        this.setLifeCycle(DIContextState.Resolving);
        for (ComponentHolder holder : this.componentList_) {
            this.resolve(holder);
        }
        if (this.unresolvableComponentList_.isEmpty()) {
            if (start) {
                this.start();
            } else {
                this.setLifeCycle(DIContextState.Resolved);
            }
        } else {
            this.setLifeCycle(DIContextState.Failed);
            this.log_.error("The following components are unresolvable:");
            for (IComponent component : this.unresolvableComponentList_) {
                this.log_.error(component.getClass());
            }
            throw new ConfigurationError("Unresolvable components");
        }
    }

    @Override
    public boolean resolveAdditionalComponent(IComponent component) {
        ComponentHolder holder = new ComponentHolder(component);
        if (this.resolve(holder)) {
            this.start(holder);
            return true;
        }
        return false;
    }

    private boolean resolve(ComponentHolder holder) {
        boolean result = true;
        IComponent component = holder.getComponent();
        block10: for (Dependency<?> dependency : holder.getComponentDescriptor().getDependencies()) {
            List<ComponentHolder> providers = this.providedInterfaceMap_.get(dependency.getRequiredInterface());
            if (providers == null || providers.size() == 0) {
                switch (dependency.getCardinality()) {
                    case zeroOrOne: 
                    case zeroOrMore: {
                        continue block10;
                    }
                    case one: 
                    case oneOrMore: {
                        this.log_.error("Unsatisfied dependency from " + component.getClass() + " to " + dependency.getRequiredInterface());
                        result = false;
                        this.unresolvableComponentList_.add(component);
                        continue block10;
                    }
                }
                throw new IllegalStateException(UNREACHABLE_CODE);
            }
            try {
                switch (dependency.getCardinality()) {
                    case zeroOrOne: 
                    case one: {
                        if (providers.size() == 1) {
                            this.doBind(providers.get(0), dependency, holder);
                            break;
                        }
                        this.log_.error("Multiple providers of dependency " + dependency.getRequiredInterface() + " for " + component.getClass());
                        for (ComponentHolder provider : providers) {
                            this.log_.error("Provided by " + provider.getComponent());
                        }
                        result = false;
                        this.unresolvableComponentList_.add(component);
                        break;
                    }
                    case zeroOrMore: 
                    case oneOrMore: {
                        for (ComponentHolder provider : providers) {
                            this.doBind(provider, dependency, holder);
                        }
                        continue block10;
                    }
                    default: {
                        throw new IllegalStateException(UNREACHABLE_CODE);
                    }
                }
            }
            catch (RuntimeException e) {
                this.log_.error("Unable to bind dependency " + dependency.getRequiredInterface() + " for " + component.getClass(), e);
                this.unresolvableComponentList_.add(component);
                result = false;
                throw e;
            }
        }
        return result;
    }

    @Override
    public synchronized void start() {
        this.setLifeCycle(DIContextState.Starting);
        for (ComponentHolder holder : this.componentList_) {
            try {
                this.start(holder);
            }
            catch (RuntimeException ex) {
                this.log_.error("Unable to start component " + holder.getName(), ex);
                this.setLifeCycle(DIContextState.Failed);
                this.doStop();
                this.log_.error("Faild to start cleanly : CALLING System.exit()");
                System.exit(1);
            }
        }
        this.setLifeCycle(DIContextState.Running);
    }

    private void start(ComponentHolder holder) {
        this.log_.debug("Start " + holder.getName());
        for (Runnable handler : holder.getComponentDescriptor().getStartHandlers()) {
            handler.run();
        }
        this.stopStack_.push(holder);
    }

    private void doBind(ComponentHolder providerHolder, Dependency<?> dependency, ComponentHolder componentHolder) {
        this.log_.debug("Binding dependency " + dependency.getRequiredInterface().getSimpleName() + " from " + providerHolder.getName() + " for " + componentHolder.getName());
        dependency.bind(providerHolder.getComponent());
        componentHolder.addDependency(providerHolder, dependency);
    }

    @Override
    public void stop() {
        this.setLifeCycle(DIContextState.Stopping);
        if (this.doStop()) {
            this.log_.error("Faild to stop cleanly : CALLING System.exit()");
            System.exit(1);
        }
        this.setLifeCycle(DIContextState.Stopped);
    }

    private boolean doStop() {
        boolean terminate = false;
        while (!this.stopStack_.isEmpty()) {
            ComponentHolder holder = this.stopStack_.pop();
            try {
                this.log_.debug("Stop " + holder.getName());
                for (Runnable handler : holder.getComponentDescriptor().getStopHandlers()) {
                    handler.run();
                }
            }
            catch (RuntimeException ex) {
                this.log_.error("Unable to stop component " + holder.getName(), ex);
                terminate = true;
                this.setLifeCycle(DIContextState.Failed);
            }
        }
        return terminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DIContextState getLifeCycle() {
        Object object = this.lifeCycleLock_;
        synchronized (object) {
            return this.lifeCycle_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLifeCycle(DIContextState lifeCycle) {
        Object object = this.lifeCycleLock_;
        synchronized (object) {
            this.lifeCycle_ = lifeCycle;
            this.lifeCycleLock_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForLifeCycle(DIContextState lifeCycle) throws InterruptedException {
        Object object = this.lifeCycleLock_;
        synchronized (object) {
            while (this.lifeCycle_ != lifeCycle) {
                this.lifeCycleLock_.wait();
            }
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.waitForLifeCycle(DIContextState.Stopped);
    }
}

