/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.example.pubsub;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.ServiceOptions;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.fugue.example.pubsub.AbstractPubSubServlet;

public class PubServlet
extends AbstractPubSubServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log_ = LoggerFactory.getLogger(PubServlet.class);

    public PubServlet() {
        super("Publisher");
    }

    public String getUrlPath() {
        return "/pub";
    }

    @Override
    public void handleGet(PrintWriter out) {
        out.println("<h2>Enter Message</h2>");
        out.println("<form method=\"POST\">");
        out.println("<textArea name=message rows=10 cols=60>");
        out.println("Enter message here");
        out.println("</textArea><br/>");
        out.println("<button type=\"submit\">Publish</button>");
        out.println("</form>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void handlePost(PrintWriter out, HttpServletRequest req) {
        block16: {
            String message = req.getParameter("message");
            TopicName topicName = TopicName.of((String)ServiceOptions.getDefaultProjectId(), (String)"Test-Topic");
            Publisher publisher = null;
            ArrayList<ApiFuture> messageIdFutures = new ArrayList<ApiFuture>();
            publisher = Publisher.newBuilder((TopicName)topicName).build();
            ByteString data = ByteString.copyFromUtf8((String)message);
            PubsubMessage pubsubMessage = PubsubMessage.newBuilder().setData(data).build();
            ApiFuture messageIdFuture = publisher.publish(pubsubMessage);
            messageIdFutures.add(messageIdFuture);
            try {
                List messageIds = (List)ApiFutures.allAsList(messageIdFutures).get();
                for (String messageId : messageIds) {
                    out.println("Published with message ID: " + messageId);
                }
                if (publisher != null) {
                    publisher.shutdown();
                }
                break block16;
            }
            catch (Exception e) {
                log_.error("Failed to shutdown publisher", (Throwable)e);
                this.error("Failed to shutdown publisher (%s)", e);
            }
            break block16;
            catch (IOException e) {
                log_.error("Failed to publish", (Throwable)e);
                this.error("Failed to publish (%s)", e);
                try {
                    List messageIds = (List)ApiFutures.allAsList(messageIdFutures).get();
                    for (String messageId : messageIds) {
                        out.println("Published with message ID: " + messageId);
                    }
                    if (publisher != null) {
                        publisher.shutdown();
                    }
                }
                catch (Exception e2) {
                    log_.error("Failed to shutdown publisher", (Throwable)e2);
                    this.error("Failed to shutdown publisher (%s)", e2);
                }
                catch (Throwable throwable) {
                    try {
                        List messageIds = (List)ApiFutures.allAsList(messageIdFutures).get();
                        for (String messageId : messageIds) {
                            out.println("Published with message ID: " + messageId);
                        }
                        if (publisher != null) {
                            publisher.shutdown();
                        }
                    }
                    catch (Exception e3) {
                        log_.error("Failed to shutdown publisher", (Throwable)e3);
                        this.error("Failed to shutdown publisher (%s)", e3);
                    }
                    throw throwable;
                }
            }
        }
    }
}

