/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.example.pubsub;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.ServiceOptions;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.common.fault.ProgramFault;
import org.symphonyoss.s2.common.http.IUrlPathServlet;
import org.symphonyoss.s2.fugue.FugueServer;
import org.symphonyoss.s2.fugue.example.pubsub.IPubSubExmple;
import org.symphonyoss.s2.fugue.example.pubsub.PubServlet;
import org.symphonyoss.s2.fugue.example.pubsub.SubServlet;

public class PubSubExmple
extends FugueServer
implements IPubSubExmple {
    public static final String TOPIC_NAME = "Test-Topic";
    public static final String SUBSCRIPTION_NAME = "Test-Topic-Subscription";
    private static final Logger log_ = LoggerFactory.getLogger(PubSubExmple.class);
    private StringBuilder status_ = new StringBuilder("Initializing...\n");

    public PubSubExmple() {
        super("PubSubExmple", 8080, new Object[0]);
        this.registerServlet((IUrlPathServlet)new PubServlet(this));
        this.registerServlet((IUrlPathServlet)new SubServlet(this));
    }

    @Override
    public void appendStatus(String message) {
        this.status_.append(message);
        if (!message.endsWith("\n")) {
            this.status_.append('\n');
        }
    }

    @Override
    public String getStatus() {
        return this.status_.toString();
    }

    public FugueServer start() {
        super.start();
        String projectId = ServiceOptions.getDefaultProjectId();
        this.createTopic(projectId);
        return this;
    }

    private void createTopic(String projectId) {
        log_.info("About to create topic");
        TopicName topicName = TopicName.of((String)projectId, (String)TOPIC_NAME);
        try (TopicAdminClient topicAdminClient = TopicAdminClient.create();){
            Topic topic = topicAdminClient.createTopic(topicName);
            this.appendStatus("Created topic");
            log_.info("Topic {} created.", (Object)topic);
            this.createSubscription(projectId, topicName);
        }
        catch (ApiException e) {
            switch (e.getStatusCode().getCode()) {
                case ALREADY_EXISTS: {
                    this.appendStatus("Topic already exists");
                    this.createSubscription(projectId, topicName);
                    break;
                }
                default: {
                    this.appendStatus("Cannot create topic: " + e.getStatusCode().getCode());
                    log_.error("Failed to create topic, HTTP {} retryable {}", new Object[]{e.getStatusCode().getCode(), e.isRetryable(), e});
                    throw new ProgramFault((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log_.error("Failed to create topic", (Throwable)e);
            throw new ProgramFault((Throwable)e);
        }
    }

    private void createSubscription(String projectId, TopicName topicName) {
        log_.info("About to create subscription");
        SubscriptionName subscriptionName = SubscriptionName.of((String)projectId, (String)SUBSCRIPTION_NAME);
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create();){
            Subscription subscription = subscriptionAdminClient.createSubscription(subscriptionName, topicName, PushConfig.getDefaultInstance(), 0);
            log_.info("Subscription {} created.", (Object)subscription);
        }
        catch (ApiException e) {
            switch (e.getStatusCode().getCode()) {
                case ALREADY_EXISTS: {
                    this.appendStatus("Subscription already exists");
                    break;
                }
                default: {
                    this.appendStatus("Cannot create subscription: " + e.getStatusCode().getCode());
                }
            }
            log_.error("Failed to create topic, HTTP {} retryable {}", new Object[]{e.getStatusCode().getCode(), e.isRetryable(), e});
        }
        catch (Exception e) {
            log_.error("Failed to create topic", (Throwable)e);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        new PubSubExmple().start().join();
    }
}

