/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.example.pubsub;

import com.google.cloud.ServiceOptions;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.ReceivedMessage;
import com.google.pubsub.v1.SubscriptionName;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.fugue.example.pubsub.AbstractPubSubServlet;
import org.symphonyoss.s2.fugue.example.pubsub.PubSubExmple;

public class SubServlet
extends AbstractPubSubServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log_ = LoggerFactory.getLogger(SubServlet.class);

    public SubServlet(PubSubExmple pubSubExample) {
        super(pubSubExample, "Subscriber");
    }

    public String getUrlPath() {
        return "/sub";
    }

    @Override
    public void handleGet(PrintWriter out) {
        try {
            SubscriptionAdminSettings subscriptionAdminSettings = SubscriptionAdminSettings.newBuilder().build();
            try (GrpcSubscriberStub subscriber = GrpcSubscriberStub.create((SubscriptionAdminSettings)subscriptionAdminSettings);){
                String projectId = ServiceOptions.getDefaultProjectId();
                String subscriptionId = "Test-Topic-Subscription";
                int numOfMessages = 1;
                String subscriptionName = SubscriptionName.of((String)projectId, (String)subscriptionId).toString();
                PullRequest pullRequest = PullRequest.newBuilder().setMaxMessages(numOfMessages).setReturnImmediately(true).setSubscription(subscriptionName).build();
                PullResponse pullResponse = (PullResponse)subscriber.pullCallable().call((Object)pullRequest);
                ArrayList<String> ackIds = new ArrayList<String>();
                for (ReceivedMessage message : pullResponse.getReceivedMessagesList()) {
                    out.println("Received message<pre>");
                    out.println(new String(message.getMessage().getData().toByteArray()));
                    out.println("</pre>");
                    ackIds.add(message.getAckId());
                }
                if (ackIds.isEmpty()) {
                    out.println("No message available");
                } else {
                    AcknowledgeRequest acknowledgeRequest = AcknowledgeRequest.newBuilder().setSubscription(subscriptionName).addAllAckIds(ackIds).build();
                    subscriber.acknowledgeCallable().call((Object)acknowledgeRequest);
                }
            }
        }
        catch (Exception e) {
            log_.error("Failed to subscribe", (Throwable)e);
            this.error("Failed to subscribe (%s)", e);
        }
    }
}

