/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.common.fault.ProgramFault;
import org.symphonyoss.s2.common.fault.TransactionFault;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;
import org.symphonyoss.s2.fugue.pubsub.IPublisher;

public class FilePerTopicPublisher
implements IPublisher<String>,
AutoCloseable {
    static final int MAX_MESSAGE_SIZE = 100000000;
    private static final Logger log_ = LoggerFactory.getLogger(FilePerTopicPublisher.class);
    private static final String NOT_OPEN = "Not open.";
    private final File rootDir_;
    private FileOutputStream out_;

    public FilePerTopicPublisher(File rootDir) {
        this.rootDir_ = rootDir;
    }

    public void startByName(String topicName) {
        if (this.out_ != null) {
            throw new IllegalStateException("Publisher is running");
        }
        try {
            this.out_ = new FileOutputStream(new File(this.rootDir_, topicName));
        }
        catch (FileNotFoundException e) {
            throw new ProgramFault((Throwable)e);
        }
    }

    public synchronized void consume(String item, ITraceContext trace) {
        if (this.out_ == null) {
            throw new IllegalStateException("Publisher is closed");
        }
        try {
            this.out_.write(item.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new TransactionFault("Unable to write message", (Throwable)e);
        }
    }

    public void flush() {
        if (this.out_ != null) {
            try {
                this.out_.flush();
            }
            catch (IOException e) {
                log_.error("Unable to flush stream", (Throwable)e);
            }
        } else {
            throw new IllegalStateException(NOT_OPEN);
        }
    }

    @Override
    public void close() {
        if (this.out_ != null) {
            try {
                this.out_.close();
            }
            catch (IOException e) {
                log_.error("Failed to close file", (Throwable)e);
            }
            finally {
                this.out_ = null;
            }
        } else {
            throw new IllegalStateException(NOT_OPEN);
        }
    }

    @Override
    public int getMaximumMessageSize() {
        return 100000000;
    }
}

