/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.symphonyoss.s2.common.fluent.IFluent;
import org.symphonyoss.s2.fugue.FugueLifecycleComponent;
import org.symphonyoss.s2.fugue.pipeline.IThreadSafeRetryableConsumer;
import org.symphonyoss.s2.fugue.pubsub.Subscription;

public abstract class AbstractSubscriberBase<P, T extends IFluent<T>>
extends FugueLifecycleComponent<T> {
    private List<Subscription<P>> subscribers_ = new ArrayList<Subscription<P>>();

    protected AbstractSubscriberBase(Class<T> type) {
        super(type);
    }

    protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionName, String topicName, String ... additionalTopicNames) {
        this.assertConfigurable();
        ArrayList<String> topicNames = new ArrayList<String>();
        topicNames.add(topicName);
        if (additionalTopicNames != null) {
            for (String name : additionalTopicNames) {
                topicNames.add(name);
            }
        }
        this.subscribers_.add(new Subscription<P>(topicNames, subscriptionName, consumer));
        return (T)this.self();
    }

    protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionName, List<String> topicNames) {
        this.assertConfigurable();
        if (topicNames.isEmpty()) {
            throw new IllegalArgumentException("At least one topic name is required");
        }
        this.subscribers_.add(new Subscription<P>(topicNames, subscriptionName, consumer));
        return (T)this.self();
    }

    protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionName, String[] topicNames) {
        this.assertConfigurable();
        if (topicNames == null || topicNames.length == 0) {
            throw new IllegalArgumentException("At least one topic name is required");
        }
        ArrayList<String> topicNameList = new ArrayList<String>();
        for (String name : topicNames) {
            topicNameList.add(name);
        }
        this.subscribers_.add(new Subscription<P>(topicNameList, subscriptionName, consumer));
        return (T)this.self();
    }

    protected List<Subscription<P>> getSubscribers() {
        return this.subscribers_;
    }
}

