/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub.file;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.pubsub.AbstractPublisherManager;
import org.symphonyoss.s2.fugue.pubsub.IPublisher;
import org.symphonyoss.s2.fugue.pubsub.file.FilePerTopicPublisher;

public class FilePerTopicPublisherManager
extends AbstractPublisherManager<String, FilePerTopicPublisherManager> {
    private final File rootDir_;
    private final INameFactory nameFactory_;
    private Map<String, FilePerTopicPublisher> publisherNameMap_ = new HashMap<String, FilePerTopicPublisher>();
    private List<FilePerTopicPublisher> publishers_ = new ArrayList<FilePerTopicPublisher>();

    public FilePerTopicPublisherManager(File rootDir, INameFactory nameFactory) {
        super(FilePerTopicPublisherManager.class);
        this.rootDir_ = rootDir;
        this.nameFactory_ = nameFactory;
    }

    public void start() {
        for (Map.Entry<String, FilePerTopicPublisher> entry : this.publisherNameMap_.entrySet()) {
            entry.getValue().startByName(this.nameFactory_.getTopicName(entry.getKey()).toString());
            this.publishers_.add(entry.getValue());
        }
    }

    public void stop() {
        for (FilePerTopicPublisher publisher : this.publishers_) {
            publisher.close();
        }
    }

    public void flush() {
        for (FilePerTopicPublisher publisher : this.publishers_) {
            publisher.flush();
        }
    }

    @Override
    public synchronized IPublisher<String> getPublisherByName(String topicName) {
        this.assertConfigurable();
        FilePerTopicPublisher publisher = this.publisherNameMap_.get(topicName);
        if (publisher == null) {
            publisher = new FilePerTopicPublisher(this.rootDir_);
            this.publisherNameMap_.put(topicName, publisher);
        }
        return publisher;
    }

    @Override
    public int getMaximumMessageSize() {
        return 100000000;
    }
}

