/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.symphonyoss.s2.common.fluent.IFluent;
import org.symphonyoss.s2.fugue.FugueLifecycleComponent;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pipeline.IThreadSafeRetryableConsumer;
import org.symphonyoss.s2.fugue.pubsub.Subscription;
import org.symphonyoss.s2.fugue.pubsub.SubscriptionImpl;

public abstract class AbstractSubscriberBase<P, T extends IFluent<T>>
extends FugueLifecycleComponent<T> {
    protected final INameFactory nameFactory_;
    protected List<SubscriptionImpl<P>> subscribers_ = new ArrayList<SubscriptionImpl<P>>();

    protected AbstractSubscriberBase(INameFactory nameFactory, Class<T> type) {
        super(type);
        this.nameFactory_ = nameFactory;
    }

    protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, Subscription subscription) {
        this.assertConfigurable();
        this.subscribers_.add(new SubscriptionImpl<P>(subscription.createTopicNames(this.nameFactory_), subscription.createObsoleteTopicNames(this.nameFactory_), subscription.getId(), subscription.getObsoleteId(), consumer));
        return (T)this.self();
    }

    @Deprecated
    protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, String topicId, String ... additionalTopicIds) {
        this.assertConfigurable();
        this.subscribers_.add(new SubscriptionImpl<P>(this.nameFactory_.getTopicNameCollection(topicId, additionalTopicIds), this.nameFactory_.getObsoleteTopicNameCollection(topicId, additionalTopicIds), null, subscriptionId, consumer));
        return (T)this.self();
    }

    protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, Collection<TopicName> topicNames) {
        this.assertConfigurable();
        if (topicNames.isEmpty()) {
            throw new IllegalArgumentException("At least one topic name is required");
        }
        this.subscribers_.add(new SubscriptionImpl<P>(topicNames, subscriptionId, consumer));
        return (T)this.self();
    }

    protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, String[] topicIds) {
        this.assertConfigurable();
        if (topicIds == null || topicIds.length == 0) {
            throw new IllegalArgumentException("At least one topic name is required");
        }
        ArrayList<TopicName> topicNameList = new ArrayList<TopicName>(topicIds.length);
        ArrayList<TopicName> obsoleteTopicNameList = new ArrayList<TopicName>(topicIds.length);
        for (String id : topicIds) {
            topicNameList.add(this.nameFactory_.getTopicName(id));
            obsoleteTopicNameList.add(this.nameFactory_.getObsoleteTopicName(id));
        }
        this.subscribers_.add(new SubscriptionImpl<P>(topicNameList, obsoleteTopicNameList, null, subscriptionId, consumer));
        return (T)this.self();
    }

    protected List<SubscriptionImpl<P>> getSubscribers() {
        return this.subscribers_;
    }
}

