/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.common.fluent.IFluent;
import org.symphonyoss.s2.fugue.FugueLifecycleState;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.naming.SubscriptionName;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pubsub.AbstractSubscriberBase;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberAdmin;
import org.symphonyoss.s2.fugue.pubsub.Subscription;
import org.symphonyoss.s2.fugue.pubsub.SubscriptionImpl;

public abstract class AbstractSubscriberAdmin<P, T extends ISubscriberAdmin & IFluent<T>>
extends AbstractSubscriberBase<P, T>
implements ISubscriberAdmin {
    private static final Logger log_ = LoggerFactory.getLogger(AbstractSubscriberAdmin.class);

    protected AbstractSubscriberAdmin(INameFactory nameFactory, Class<T> type) {
        super(nameFactory, type);
    }

    @Override
    public ISubscriberAdmin withSubscription(Subscription subscription) {
        return (ISubscriberAdmin)super.withSubscription(null, subscription);
    }

    public T withSubscription(String subscriptionId, String topicId, String ... additionalTopicIds) {
        return (T)((ISubscriberAdmin)super.withSubscription(null, subscriptionId, topicId, additionalTopicIds));
    }

    public T withSubscription(String subscriptionId, Collection<TopicName> topicNames) {
        return (T)((ISubscriberAdmin)super.withSubscription(null, subscriptionId, topicNames));
    }

    public T withSubscription(String subscriptionId, String[] topicNames) {
        return (T)((ISubscriberAdmin)super.withSubscription(null, subscriptionId, topicNames));
    }

    public synchronized void start() {
        this.setLifeCycleState(FugueLifecycleState.Running);
    }

    public synchronized void stop() {
        this.setLifeCycleState(FugueLifecycleState.Stopped);
    }

    protected abstract void createSubcription(TopicName var1, SubscriptionName var2, boolean var3);

    protected abstract void deleteSubcription(TopicName var1, SubscriptionName var2, boolean var3);

    @Override
    public void createSubscriptions(boolean dryRun) {
        log_.info("About to create subscriptions...");
        for (SubscriptionImpl subscription : this.getSubscribers()) {
            for (TopicName topicName : subscription.getObsoleteTopicNames()) {
                this.deleteSubcription(topicName, this.nameFactory_.getObsoleteSubscriptionName(topicName, subscription.getObsoleteSubscriptionId()), dryRun);
            }
            for (TopicName topicName : subscription.getTopicNames()) {
                this.deleteSubcription(topicName, this.nameFactory_.getObsoleteSubscriptionName(topicName, subscription.getObsoleteSubscriptionId()), dryRun);
                this.createSubcription(topicName, this.nameFactory_.getSubscriptionName(topicName, subscription.getSubscriptionId()), dryRun);
            }
        }
    }

    @Override
    public void deleteSubscriptions(boolean dryRun) {
        log_.info("About to delete subscriptions...");
        for (SubscriptionImpl subscription : this.getSubscribers()) {
            log_.info("About to delete subscriptions... subscriptionId=" + subscription.getSubscriptionId());
            for (TopicName topicName : subscription.getObsoleteTopicNames()) {
                log_.info("About to delete subscriptions... topicName=" + topicName);
                this.deleteSubcription(topicName, this.nameFactory_.getObsoleteSubscriptionName(topicName, subscription.getObsoleteSubscriptionId()), dryRun);
            }
            for (TopicName topicName : subscription.getTopicNames()) {
                this.deleteSubcription(topicName, this.nameFactory_.getObsoleteSubscriptionName(topicName, subscription.getObsoleteSubscriptionId()), dryRun);
                this.deleteSubcription(topicName, this.nameFactory_.getSubscriptionName(topicName, subscription.getSubscriptionId()), dryRun);
            }
        }
    }
}

