/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pubsub.Topic;

public class Subscription {
    private String id_;
    private String obsoleteId_;
    private List<Topic> topics_ = new LinkedList<Topic>();

    public Subscription withId(String id) {
        this.id_ = id;
        return this;
    }

    public Subscription withObsoleteId(String obsoleteId) {
        this.obsoleteId_ = obsoleteId;
        return this;
    }

    public Subscription withTopic(Topic topic) {
        this.topics_.add(topic);
        return this;
    }

    public Subscription withTopic(String topicId) {
        this.topics_.add(new Topic(topicId));
        return this;
    }

    public String getId() {
        return this.id_;
    }

    public String getObsoleteId() {
        return this.obsoleteId_;
    }

    public Collection<TopicName> createTopicNames(INameFactory nameFactory) {
        LinkedList<TopicName> names = new LinkedList<TopicName>();
        for (Topic t : this.topics_) {
            names.add(t.createTopicName(nameFactory));
        }
        return names;
    }

    @Deprecated
    public Collection<TopicName> createObsoleteTopicNames(INameFactory nameFactory) {
        LinkedList<TopicName> names = new LinkedList<TopicName>();
        for (Topic t : this.topics_) {
            names.add(t.createObsoleteTopicName(nameFactory));
        }
        return names;
    }
}

