/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.symphonyoss.s2.common.fault.FaultAccumulator;
import org.symphonyoss.s2.common.fluent.BaseAbstractBuilder;
import org.symphonyoss.s2.fugue.FugueLifecycleComponent;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pipeline.IThreadSafeRetryableConsumer;
import org.symphonyoss.s2.fugue.pubsub.Subscription;
import org.symphonyoss.s2.fugue.pubsub.SubscriptionImpl;

public abstract class AbstractSubscriberBase<P, T extends AbstractSubscriberBase<P, T>>
extends FugueLifecycleComponent<T> {
    protected final INameFactory nameFactory_;
    protected final ImmutableList<SubscriptionImpl<P>> subscribers_;
    protected final int totalSubscriptionCnt_;

    protected AbstractSubscriberBase(Class<T> type, Builder<P, ?, T> builder) {
        super(type);
        this.nameFactory_ = ((Builder)builder).nameFactory_;
        this.subscribers_ = ImmutableList.copyOf((Collection)((Builder)builder).subscribers_);
        this.totalSubscriptionCnt_ = ((Builder)builder).totalSubscriptionCnt_;
    }

    protected List<SubscriptionImpl<P>> getSubscribers() {
        return this.subscribers_;
    }

    protected int getTotalSubscriptionCnt() {
        return this.totalSubscriptionCnt_;
    }

    public static abstract class Builder<P, T extends Builder<P, T, B>, B extends AbstractSubscriberBase<P, B>>
    extends BaseAbstractBuilder<T, B> {
        private INameFactory nameFactory_;
        private int totalSubscriptionCnt_;
        private List<SubscriptionImpl<P>> subscribers_ = new ArrayList<SubscriptionImpl<P>>();
        private List<Runnable> taskList_ = new ArrayList<Runnable>();

        protected Builder(Class<T> type) {
            super(type);
        }

        public T withNameFactory(INameFactory nameFactory) {
            this.nameFactory_ = nameFactory;
            return (T)((Object)((Builder)this.self()));
        }

        protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, Subscription subscription) {
            this.taskList_.add(() -> {
                Collection<TopicName> topicNames = subscription.createTopicNames(this.nameFactory_);
                this.subscribers_.add(new SubscriptionImpl(topicNames, subscription.createObsoleteTopicNames(this.nameFactory_), subscription.getId(), subscription.getObsoleteId(), consumer));
                this.totalSubscriptionCnt_ += topicNames.size();
            });
            return (T)((Object)((Builder)this.self()));
        }

        @Deprecated
        protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, String topicId, String ... additionalTopicIds) {
            this.taskList_.add(() -> {
                Collection topicNames = this.nameFactory_.getTopicNameCollection(topicId, additionalTopicIds);
                this.subscribers_.add(new SubscriptionImpl(topicNames, this.nameFactory_.getObsoleteTopicNameCollection(topicId, additionalTopicIds), null, subscriptionId, consumer));
                this.totalSubscriptionCnt_ += topicNames.size();
            });
            return (T)((Object)((Builder)this.self()));
        }

        protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, Collection<TopicName> topicNames) {
            if (topicNames.isEmpty()) {
                throw new IllegalArgumentException("At least one topic name is required");
            }
            this.subscribers_.add(new SubscriptionImpl<P>(topicNames, subscriptionId, consumer));
            this.totalSubscriptionCnt_ += topicNames.size();
            return (T)((Object)((Builder)this.self()));
        }

        protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, String[] topicIds) {
            if (topicIds == null || topicIds.length == 0) {
                throw new IllegalArgumentException("At least one topic name is required");
            }
            this.taskList_.add(() -> {
                ArrayList<TopicName> topicNameList = new ArrayList<TopicName>(topicIds.length);
                ArrayList<TopicName> obsoleteTopicNameList = new ArrayList<TopicName>(topicIds.length);
                for (String id : topicIds) {
                    topicNameList.add(this.nameFactory_.getTopicName(id));
                    obsoleteTopicNameList.add(this.nameFactory_.getObsoleteTopicName(id));
                }
                this.subscribers_.add(new SubscriptionImpl(topicNameList, obsoleteTopicNameList, null, subscriptionId, consumer));
                this.totalSubscriptionCnt_ += topicNameList.size();
            });
            return (T)((Object)((Builder)this.self()));
        }

        public void validate(FaultAccumulator faultAccumulator) {
            super.validate(faultAccumulator);
            faultAccumulator.checkNotNull((Object)this.nameFactory_, "nameFactory");
            for (Runnable task : this.taskList_) {
                task.run();
            }
        }
    }
}

