/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.fugue.FugueLifecycleState;
import org.symphonyoss.s2.fugue.naming.SubscriptionName;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pubsub.AbstractSubscriberBase;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberAdmin;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberAdminBuilder;
import org.symphonyoss.s2.fugue.pubsub.Subscription;
import org.symphonyoss.s2.fugue.pubsub.SubscriptionImpl;

public abstract class AbstractSubscriberAdmin<T extends AbstractSubscriberAdmin<T>>
extends AbstractSubscriberBase<Void, T>
implements ISubscriberAdmin<T> {
    private static final Logger log_ = LoggerFactory.getLogger(AbstractSubscriberAdmin.class);
    protected final List<SubscriptionImpl<?>> obsoleteSubscribers_;

    protected AbstractSubscriberAdmin(Class<T> type, Builder<?, T> builder) {
        super(type, builder);
        this.obsoleteSubscribers_ = builder.obsoleteSubscribers_;
    }

    public synchronized void start() {
        this.setLifeCycleState(FugueLifecycleState.Running);
    }

    public synchronized void stop() {
        this.setLifeCycleState(FugueLifecycleState.Stopped);
    }

    protected abstract void createSubcription(TopicName var1, SubscriptionName var2, boolean var3);

    protected abstract void deleteSubcription(TopicName var1, SubscriptionName var2, boolean var3);

    @Override
    public void createSubscriptions(boolean dryRun) {
        log_.info("About to create subscriptions...");
        for (SubscriptionImpl subscription : this.getSubscribers()) {
            for (TopicName topicName : subscription.getTopicNames()) {
                this.createSubcription(topicName, this.nameFactory_.getSubscriptionName(topicName, subscription.getSubscriptionId()), dryRun);
            }
        }
        this.deleteObsoleteSubscriptions(dryRun);
    }

    @Override
    public void deleteSubscriptions(boolean dryRun) {
        log_.info("About to delete subscriptions...");
        for (SubscriptionImpl subscription : this.getSubscribers()) {
            log_.info("About to delete subscriptions... subscriptionId=" + subscription.getSubscriptionId());
            for (TopicName topicName : subscription.getTopicNames()) {
                this.deleteSubcription(topicName, this.nameFactory_.getSubscriptionName(topicName, subscription.getSubscriptionId()), dryRun);
            }
        }
        this.deleteObsoleteSubscriptions(dryRun);
    }

    private void deleteObsoleteSubscriptions(boolean dryRun) {
        for (SubscriptionImpl<?> subscription : this.obsoleteSubscribers_) {
            log_.info("About to delete obsolete subscriptions... subscriptionId=" + subscription.getSubscriptionId());
            for (TopicName topicName : subscription.getTopicNames()) {
                this.deleteSubcription(topicName, this.nameFactory_.getSubscriptionName(topicName, subscription.getSubscriptionId()), dryRun);
            }
        }
    }

    public static abstract class Builder<T extends Builder<T, B>, B extends AbstractSubscriberAdmin<B>>
    extends AbstractSubscriberBase.Builder<Void, T, B>
    implements ISubscriberAdminBuilder<T, B> {
        protected List<SubscriptionImpl<?>> obsoleteSubscribers_ = new ArrayList();

        protected Builder(Class<T> type) {
            super(type);
        }

        @Override
        public T withSubscription(Subscription subscription) {
            return (T)((Builder)super.withSubscription(null, subscription));
        }

        @Override
        public T withObsoleteSubscription(String subscriptionId, String topicId, String ... additionalTopicIds) {
            this.taskList_.add(() -> {
                Collection topicNames = this.nameFactory_.getTopicNameCollection(topicId, additionalTopicIds);
                this.obsoleteSubscribers_.add(new SubscriptionImpl(topicNames, subscriptionId, null));
            });
            return (T)((Builder)this.self());
        }

        @Override
        public T withSubscription(String subscriptionId, String topicId, String ... additionalTopicIds) {
            return (T)((Builder)super.withSubscription(null, subscriptionId, topicId, additionalTopicIds));
        }

        @Override
        public T withSubscription(String subscriptionId, Collection<TopicName> topicNames) {
            return (T)((Builder)super.withSubscription(null, subscriptionId, topicNames));
        }

        @Override
        public T withSubscription(String subscriptionId, String[] topicNames) {
            return (T)((Builder)super.withSubscription(null, subscriptionId, topicNames));
        }
    }
}

