/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.symphonyoss.s2.common.fault.FaultAccumulator;
import org.symphonyoss.s2.common.fluent.BaseAbstractBuilder;
import org.symphonyoss.s2.fugue.FugueLifecycleComponent;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pipeline.IThreadSafeRetryableConsumer;
import org.symphonyoss.s2.fugue.pubsub.Subscription;
import org.symphonyoss.s2.fugue.pubsub.SubscriptionImpl;

public abstract class AbstractSubscriberBase<P, T extends AbstractSubscriberBase<P, T>>
extends FugueLifecycleComponent<T> {
    protected final INameFactory nameFactory_;
    protected final ImmutableList<SubscriptionImpl<P>> subscribers_;
    protected final int totalSubscriptionCnt_;

    protected AbstractSubscriberBase(Class<T> type, Builder<P, ?, T> builder) {
        super(type);
        this.nameFactory_ = builder.nameFactory_;
        this.subscribers_ = ImmutableList.copyOf(builder.subscribers_);
        this.totalSubscriptionCnt_ = builder.totalSubscriptionCnt_;
    }

    protected List<SubscriptionImpl<P>> getSubscribers() {
        return this.subscribers_;
    }

    protected int getTotalSubscriptionCnt() {
        return this.totalSubscriptionCnt_;
    }

    public static abstract class Builder<P, T extends Builder<P, T, B>, B extends AbstractSubscriberBase<P, B>>
    extends BaseAbstractBuilder<T, B> {
        protected INameFactory nameFactory_;
        protected int totalSubscriptionCnt_;
        protected List<SubscriptionImpl<P>> subscribers_ = new ArrayList<SubscriptionImpl<P>>();
        protected List<Runnable> taskList_ = new ArrayList<Runnable>();

        protected Builder(Class<T> type) {
            super(type);
        }

        public T withNameFactory(INameFactory nameFactory) {
            this.nameFactory_ = nameFactory;
            return (T)((Object)((Builder)this.self()));
        }

        protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, Subscription subscription) {
            this.taskList_.add(() -> {
                Collection<TopicName> topicNames = subscription.createTopicNames(this.nameFactory_);
                this.subscribers_.add(new SubscriptionImpl(topicNames, subscription.getId(), consumer));
                this.totalSubscriptionCnt_ += topicNames.size();
            });
            return (T)((Object)((Builder)this.self()));
        }

        protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, String topicId, String ... additionalTopicIds) {
            this.taskList_.add(() -> {
                Collection topicNames = this.nameFactory_.getTopicNameCollection(topicId, additionalTopicIds);
                this.subscribers_.add(new SubscriptionImpl(topicNames, subscriptionId, consumer));
                this.totalSubscriptionCnt_ += topicNames.size();
            });
            return (T)((Object)((Builder)this.self()));
        }

        protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, Collection<TopicName> topicNames) {
            if (topicNames.isEmpty()) {
                throw new IllegalArgumentException("At least one topic name is required");
            }
            this.subscribers_.add(new SubscriptionImpl<P>(topicNames, subscriptionId, consumer));
            this.totalSubscriptionCnt_ += topicNames.size();
            return (T)((Object)((Builder)this.self()));
        }

        protected T withSubscription(@Nullable IThreadSafeRetryableConsumer<P> consumer, String subscriptionId, String[] topicIds) {
            if (topicIds == null || topicIds.length == 0) {
                throw new IllegalArgumentException("At least one topic name is required");
            }
            this.taskList_.add(() -> {
                ArrayList<TopicName> topicNameList = new ArrayList<TopicName>(topicIds.length);
                for (String id : topicIds) {
                    topicNameList.add(this.nameFactory_.getTopicName(id));
                }
                this.subscribers_.add(new SubscriptionImpl(topicNameList, subscriptionId, consumer));
                this.totalSubscriptionCnt_ += topicNameList.size();
            });
            return (T)((Object)((Builder)this.self()));
        }

        public void validate(FaultAccumulator faultAccumulator) {
            super.validate(faultAccumulator);
            faultAccumulator.checkNotNull((Object)this.nameFactory_, "nameFactory");
            for (Runnable task : this.taskList_) {
                task.run();
            }
        }
    }
}

