/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.common.fault.FaultAccumulator;
import org.symphonyoss.s2.common.fault.TransientTransactionFault;
import org.symphonyoss.s2.common.fluent.BaseAbstractBuilder;
import org.symphonyoss.s2.fugue.FugueLifecycleComponent;
import org.symphonyoss.s2.fugue.FugueLifecycleState;
import org.symphonyoss.s2.fugue.config.IConfiguration;
import org.symphonyoss.s2.fugue.core.trace.ITraceContext;
import org.symphonyoss.s2.fugue.core.trace.ITraceContextTransactionFactory;
import org.symphonyoss.s2.fugue.counter.ICounter;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.pipeline.FatalConsumerException;
import org.symphonyoss.s2.fugue.pipeline.IThreadSafeErrorConsumer;
import org.symphonyoss.s2.fugue.pipeline.IThreadSafeRetryableConsumer;
import org.symphonyoss.s2.fugue.pipeline.RetryableConsumerException;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberManager;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberManagerBuilder;
import org.symphonyoss.s2.fugue.pubsub.ISubscription;

public abstract class AbstractSubscriberManager<T extends AbstractSubscriberManager<T>>
extends FugueLifecycleComponent<T>
implements ISubscriberManager<T> {
    protected static final long FAILED_DEAD_LETTER_RETRY_TIME = TimeUnit.HOURS.toMillis(1L);
    protected static final long FAILED_CONSUMER_RETRY_TIME = TimeUnit.SECONDS.toMillis(30L);
    protected static final long MESSAGE_PROCESSED_OK = -1L;
    private static final Logger log_ = LoggerFactory.getLogger(AbstractSubscriberManager.class);
    private static final Integer FAILURE_CNT_LIMIT = 5;
    protected final INameFactory nameFactory_;
    protected final ImmutableList<ISubscription> subscribers_;
    protected final ITraceContextTransactionFactory traceFactory_;
    protected final IThreadSafeErrorConsumer<String> unprocessableMessageConsumer_;
    protected final IConfiguration config_;
    protected final ICounter counter_;
    protected final int totalSubscriptionCnt_;
    private Cache<String, Integer> failureCache_ = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();

    protected AbstractSubscriberManager(Class<T> type, Builder<?, T> builder) {
        super(type);
        this.nameFactory_ = builder.nameFactory_;
        this.subscribers_ = ImmutableList.copyOf(builder.subscribers_);
        this.traceFactory_ = builder.traceFactory_;
        this.unprocessableMessageConsumer_ = builder.unprocessableMessageConsumer_;
        this.config_ = builder.config_;
        this.counter_ = builder.counter_;
        this.totalSubscriptionCnt_ = builder.totalSubscriptionCnt_;
    }

    @Override
    public int getTotalSubscriptionCnt() {
        return this.totalSubscriptionCnt_;
    }

    protected ICounter getCounter() {
        return this.counter_;
    }

    protected abstract void initSubscription(ISubscription var1);

    protected abstract void startSubscriptions();

    protected abstract void stopSubscriptions();

    protected ITraceContextTransactionFactory getTraceFactory() {
        return this.traceFactory_;
    }

    public synchronized void start() {
        this.setLifeCycleState(FugueLifecycleState.Starting);
        for (ISubscription s : this.subscribers_) {
            this.initSubscription(s);
        }
        this.startSubscriptions();
        this.setLifeCycleState(FugueLifecycleState.Running);
    }

    public void quiesce() {
        this.setLifeCycleState(FugueLifecycleState.Quiescing);
        this.stopSubscriptions();
        this.setLifeCycleState(FugueLifecycleState.Quiescent);
    }

    public synchronized void stop() {
        this.setLifeCycleState(FugueLifecycleState.Stopping);
        this.stopSubscriptions();
        this.setLifeCycleState(FugueLifecycleState.Stopped);
    }

    public long handleMessage(IThreadSafeRetryableConsumer<String> consumer, String payload, ITraceContext trace, String messageId) {
        try {
            consumer.consume((Object)payload, trace);
        }
        catch (TransientTransactionFault e) {
            log_.warn("TransientTransactionFault, will retry (forever)", (Throwable)e);
            return this.retryMessage(payload, trace, e, messageId, FAILED_CONSUMER_RETRY_TIME, true);
        }
        catch (RetryableConsumerException e) {
            log_.warn("Unprocessable message, will retry", (Throwable)e);
            if (e.getRetryTime() == null || e.getRetryTimeUnit() == null) {
                return this.retryMessage(payload, trace, e, messageId, FAILED_CONSUMER_RETRY_TIME, false);
            }
            return this.retryMessage(payload, trace, e, messageId, e.getRetryTimeUnit().toMillis(e.getRetryTime()), false);
        }
        catch (RuntimeException e) {
            return this.retryMessage(payload, trace, e, messageId, FAILED_CONSUMER_RETRY_TIME, false);
        }
        catch (FatalConsumerException e) {
            log_.error("Unprocessable message, aborted", (Throwable)e);
            trace.trace("MESSAGE_IS_UNPROCESSABLE");
            return this.abortMessage(payload, trace, e);
        }
        return -1L;
    }

    private long retryMessage(String payload, ITraceContext trace, Throwable cause, String messageId, long retryTime, boolean retryForever) {
        if (!retryForever) {
            Integer cnt = (Integer)this.failureCache_.getIfPresent((Object)messageId);
            if (cnt == null) {
                cnt = 1;
                this.failureCache_.put((Object)messageId, (Object)cnt);
            } else {
                if (cnt >= FAILURE_CNT_LIMIT) {
                    trace.trace("MESSAGE_RETRIES_EXCEEDED");
                    this.failureCache_.invalidate((Object)messageId);
                    return this.abortMessage(payload, trace, cause);
                }
                cnt = cnt + 1;
                this.failureCache_.put((Object)messageId, (Object)cnt);
            }
            log_.warn("Message processing failed " + cnt + " times, will retry", cause);
        }
        return retryTime;
    }

    private long abortMessage(String payload, ITraceContext trace, Throwable e) {
        try {
            this.unprocessableMessageConsumer_.consume((Object)payload, trace, e.getLocalizedMessage(), e);
            return -1L;
        }
        catch (RuntimeException e2) {
            log_.error("Unprocessable message consumer failed", e);
            return FAILED_DEAD_LETTER_RETRY_TIME;
        }
    }

    protected static abstract class Builder<T extends Builder<T, B>, B extends AbstractSubscriberManager<B>>
    extends BaseAbstractBuilder<T, B>
    implements ISubscriberManagerBuilder<T, B> {
        protected INameFactory nameFactory_;
        protected List<ISubscription> subscribers_ = new LinkedList<ISubscription>();
        protected ITraceContextTransactionFactory traceFactory_;
        protected IThreadSafeErrorConsumer<String> unprocessableMessageConsumer_;
        protected IConfiguration config_;
        protected ICounter counter_;
        protected int totalSubscriptionCnt_;

        protected Builder(Class<T> type) {
            super(type);
        }

        @Override
        public T withNameFactory(INameFactory nameFactory) {
            this.nameFactory_ = nameFactory;
            return (T)((Builder)this.self());
        }

        @Override
        public T withSubscription(ISubscription subscription) {
            this.subscribers_.add(subscription);
            this.totalSubscriptionCnt_ += subscription.getSubscriptionNames().size();
            return (T)((Builder)this.self());
        }

        @Override
        public T withConfig(IConfiguration config) {
            this.config_ = config;
            return (T)((Builder)this.self());
        }

        @Override
        public T withCounter(ICounter counter) {
            this.counter_ = counter;
            return (T)((Builder)this.self());
        }

        @Override
        public T withTraceContextTransactionFactory(ITraceContextTransactionFactory traceFactory) {
            this.traceFactory_ = traceFactory;
            return (T)((Builder)this.self());
        }

        public ITraceContextTransactionFactory getTraceContextTransactionFactory() {
            return this.traceFactory_;
        }

        @Override
        public T withUnprocessableMessageConsumer(IThreadSafeErrorConsumer<String> unprocessableMessageConsumer) {
            this.unprocessableMessageConsumer_ = unprocessableMessageConsumer;
            return (T)((Builder)this.self());
        }

        public void validate(FaultAccumulator faultAccumulator) {
            super.validate(faultAccumulator);
            faultAccumulator.checkNotNull((Object)this.traceFactory_, "traceFactory");
            faultAccumulator.checkNotNull(this.unprocessableMessageConsumer_, "unprocessableMessageConsumer");
            faultAccumulator.checkNotNull((Object)this.config_, "config");
        }
    }
}

