/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.symphonyoss.s2.common.fault.FaultAccumulator;
import org.symphonyoss.s2.common.fluent.BaseAbstractBuilder;
import org.symphonyoss.s2.fugue.naming.Name;
import org.symphonyoss.s2.fugue.pubsub.ISubscriptionAdmin;

@Immutable
public class QueueSubscriptionAdmin
implements ISubscriptionAdmin {
    private final ImmutableSet<Name> subscriptionNames_;

    protected QueueSubscriptionAdmin(AbstractBuilder<?, ?> builder) {
        this.subscriptionNames_ = ((AbstractBuilder)builder).subscriptionNames_;
    }

    public ImmutableSet<Name> getSubscriptionNames() {
        return this.subscriptionNames_;
    }

    public static class Builder
    extends AbstractBuilder<Builder, QueueSubscriptionAdmin> {
        public Builder() {
            super(Builder.class);
        }

        protected QueueSubscriptionAdmin construct() {
            return new QueueSubscriptionAdmin(this);
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T, B>, B extends ISubscriptionAdmin>
    extends BaseAbstractBuilder<T, B> {
        private Set<Name> builderSubscriptionNames_ = new HashSet<Name>();
        private ImmutableSet<Name> subscriptionNames_;

        protected AbstractBuilder(Class<T> type) {
            super(type);
        }

        public T withSubscriptionNames(Name ... subscriptionNames) {
            if (subscriptionNames != null) {
                for (Name subscriptionName : subscriptionNames) {
                    this.builderSubscriptionNames_.add(subscriptionName);
                }
            }
            return (T)((Object)((AbstractBuilder)this.self()));
        }

        protected void validate(FaultAccumulator faultAccumulator) {
            super.validate(faultAccumulator);
            faultAccumulator.checkNotNull(this.builderSubscriptionNames_, "subscription names");
            this.subscriptionNames_ = ImmutableSet.copyOf(this.builderSubscriptionNames_);
        }
    }
}

