/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.common.fluent.BaseAbstractBuilder;
import org.symphonyoss.s2.fugue.FugueLifecycleComponent;
import org.symphonyoss.s2.fugue.FugueLifecycleState;
import org.symphonyoss.s2.fugue.naming.SubscriptionName;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberAdmin;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberAdminBuilder;
import org.symphonyoss.s2.fugue.pubsub.ITopicSubscriptionAdmin;

public abstract class AbstractSubscriberAdmin<T extends AbstractSubscriberAdmin<T>>
extends FugueLifecycleComponent<T>
implements ISubscriberAdmin<T> {
    private static final Logger log_ = LoggerFactory.getLogger(AbstractSubscriberAdmin.class);
    protected final ImmutableList<ITopicSubscriptionAdmin> obsoleteSubscribers_;
    protected final ImmutableList<ITopicSubscriptionAdmin> subscribers_;

    protected AbstractSubscriberAdmin(Class<T> type, Builder<?, T> builder) {
        super(type);
        this.obsoleteSubscribers_ = ImmutableList.copyOf(builder.obsoleteSubscribers_);
        this.subscribers_ = ImmutableList.copyOf(builder.subscribers_);
    }

    public synchronized void start() {
        this.setLifeCycleState(FugueLifecycleState.Running);
    }

    public synchronized void stop() {
        this.setLifeCycleState(FugueLifecycleState.Stopped);
    }

    protected abstract void createSubcription(SubscriptionName var1, boolean var2);

    protected abstract void deleteSubcription(SubscriptionName var1, boolean var2);

    @Override
    public void createSubscriptions(boolean dryRun) {
        log_.info("About to create subscriptions...");
        for (ITopicSubscriptionAdmin subscription : this.subscribers_) {
            for (SubscriptionName subscriptionName : subscription.getSubscriptionNames()) {
                this.createSubcription(subscriptionName, dryRun);
            }
        }
        this.deleteObsoleteSubscriptions(dryRun);
    }

    @Override
    public void deleteSubscriptions(boolean dryRun) {
        log_.info("About to delete subscriptions...");
        for (ITopicSubscriptionAdmin subscription : this.subscribers_) {
            for (SubscriptionName subscriptionName : subscription.getSubscriptionNames()) {
                this.deleteSubcription(subscriptionName, dryRun);
            }
        }
        this.deleteObsoleteSubscriptions(dryRun);
    }

    private void deleteObsoleteSubscriptions(boolean dryRun) {
        log_.info("About to delete obsolete subscriptions...");
        for (ITopicSubscriptionAdmin subscription : this.obsoleteSubscribers_) {
            for (SubscriptionName subscriptionName : subscription.getSubscriptionNames()) {
                this.deleteSubcription(subscriptionName, dryRun);
            }
        }
    }

    public static abstract class Builder<T extends Builder<T, B>, B extends AbstractSubscriberAdmin<B>>
    extends BaseAbstractBuilder<T, B>
    implements ISubscriberAdminBuilder<T, B> {
        protected List<ITopicSubscriptionAdmin> obsoleteSubscribers_ = new LinkedList<ITopicSubscriptionAdmin>();
        protected List<ITopicSubscriptionAdmin> subscribers_ = new LinkedList<ITopicSubscriptionAdmin>();

        protected Builder(Class<T> type) {
            super(type);
        }

        @Override
        public T withSubscription(ITopicSubscriptionAdmin subscription) {
            this.subscribers_.add(subscription);
            return (T)((Builder)this.self());
        }

        @Override
        public T withObsoleteSubscription(ITopicSubscriptionAdmin subscription) {
            this.obsoleteSubscribers_.add(subscription);
            return (T)((Builder)this.self());
        }
    }
}

