/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.symphonyoss.s2.common.fault.FaultAccumulator;
import org.symphonyoss.s2.fugue.naming.SubscriptionName;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pubsub.AbstractSubscription;
import org.symphonyoss.s2.fugue.pubsub.ISubscriptionAdmin;
import org.symphonyoss.s2.fugue.pubsub.ITopicSubscriptionAdmin;

@Immutable
public class TopicSubscriptionAdmin
implements ITopicSubscriptionAdmin {
    private final ImmutableSet<SubscriptionName> subscriptionNames_;
    private final String filterPropertyName_;
    private final boolean filterExclude_;
    private final ImmutableSet<String> filterPropertyValues_;
    private final String lambdaConsumer_;

    protected TopicSubscriptionAdmin(AbstractBuilder<?, ?> builder) {
        this.subscriptionNames_ = ((AbstractBuilder)builder).subscriptionNames_;
        this.filterPropertyName_ = ((AbstractBuilder)builder).filterPropertyName_;
        this.filterExclude_ = ((AbstractBuilder)builder).filterExclude_;
        this.filterPropertyValues_ = ImmutableSet.copyOf((Collection)((AbstractBuilder)builder).filterPropertyValues_);
        this.lambdaConsumer_ = ((AbstractBuilder)builder).lambdaConsumer_;
    }

    @Override
    public ImmutableSet<SubscriptionName> getSubscriptionNames() {
        return this.subscriptionNames_;
    }

    @Override
    public String getFilterPropertyName() {
        return this.filterPropertyName_;
    }

    @Override
    public boolean isFilterExclude() {
        return this.filterExclude_;
    }

    @Override
    public ImmutableSet<String> getFilterPropertyValues() {
        return this.filterPropertyValues_;
    }

    @Override
    public String getLambdaConsumer() {
        return this.lambdaConsumer_;
    }

    public static class Builder
    extends AbstractBuilder<Builder, TopicSubscriptionAdmin> {
        public Builder() {
            super(Builder.class);
        }

        protected TopicSubscriptionAdmin construct() {
            return new TopicSubscriptionAdmin(this);
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T, B>, B extends ISubscriptionAdmin>
    extends AbstractSubscription.AbstractBuilder<T, B> {
        private Set<String> topicIds_ = new HashSet<String>();
        private String subscriptionId_;
        private String serviceId_;
        private String filterPropertyName_;
        private boolean filterExclude_;
        private Set<String> filterPropertyValues_ = new HashSet<String>();
        private ImmutableSet<SubscriptionName> subscriptionNames_;
        private String lambdaConsumer_;

        protected AbstractBuilder(Class<T> type) {
            super(type);
        }

        public T withSubscriptionId(String subscriptionId) {
            this.subscriptionId_ = subscriptionId;
            return (T)((Object)((AbstractBuilder)this.self()));
        }

        public T withServiceId(String serviceId) {
            this.serviceId_ = serviceId;
            return (T)((Object)((AbstractBuilder)this.self()));
        }

        public T withTopicIds(String ... topicIds) {
            if (topicIds != null) {
                for (String topicId : topicIds) {
                    this.topicIds_.add(topicId);
                }
            }
            return (T)((Object)((AbstractBuilder)this.self()));
        }

        public T withFilterPropertyName(String filterPropertyName) {
            this.filterPropertyName_ = filterPropertyName;
            return (T)((Object)((AbstractBuilder)this.self()));
        }

        public T withFilterExclude(boolean filterExclude) {
            this.filterExclude_ = filterExclude;
            return (T)((Object)((AbstractBuilder)this.self()));
        }

        public T withFilterPropertyValues(String ... value) {
            if (value != null) {
                for (String topicId : value) {
                    this.filterPropertyValues_.add(topicId);
                }
            }
            return (T)((Object)((AbstractBuilder)this.self()));
        }

        public T withLambdaConsumer(String lambdaConsumer) {
            this.lambdaConsumer_ = lambdaConsumer;
            return (T)((Object)((AbstractBuilder)this.self()));
        }

        @Override
        protected void validate(FaultAccumulator faultAccumulator) {
            super.validate(faultAccumulator);
            faultAccumulator.checkNotNull(this.topicIds_, "topic ID");
            HashSet<SubscriptionName> names = new HashSet<SubscriptionName>();
            if (this.nameFactory_ != null) {
                for (String topicId : this.topicIds_) {
                    TopicName topicName = this.serviceId_ == null ? this.nameFactory_.getTopicName(topicId) : this.nameFactory_.getTopicName(this.serviceId_, topicId);
                    names.add(this.nameFactory_.getSubscriptionName(topicName, this.subscriptionId_));
                }
            }
            this.subscriptionNames_ = ImmutableSet.copyOf(names);
        }
    }
}

