/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.pubsub;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.symphonyoss.s2.common.fault.FaultAccumulator;
import org.symphonyoss.s2.common.fluent.BaseAbstractBuilder;
import org.symphonyoss.s2.common.fluent.IFluent;
import org.symphonyoss.s2.fugue.FugueLifecycleComponent;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pubsub.IPublisher;
import org.symphonyoss.s2.fugue.pubsub.IPublisherManager;

public abstract class AbstractPublisherManager<T extends AbstractPublisherManager<T>>
extends FugueLifecycleComponent<T>
implements IPublisherManager {
    protected final INameFactory nameFactory_;

    protected AbstractPublisherManager(Class<T> builtType, Builder<?, T> builder) {
        super(builtType);
        this.nameFactory_ = ((Builder)builder).nameFactory_;
    }

    @Override
    public IPublisher getPublisherByName(String topicId) {
        return this.getPublisherByName(this.nameFactory_.getTopicName(topicId));
    }

    @Override
    public IPublisher getPublisherByName(String serviceId, String topicId) {
        return this.getPublisherByName(this.nameFactory_.getTopicName(serviceId, topicId));
    }

    public static abstract class Builder<T extends Builder<T, B>, B extends IFluent<B>>
    extends BaseAbstractBuilder<T, B> {
        private final List<String> topicIds_ = new LinkedList<String>();
        private final Map<String, List<String>> serviceTopicIds_ = new HashMap<String, List<String>>();
        private INameFactory nameFactory_;

        protected Builder(Class<T> type) {
            super(type);
        }

        public T withNameFactory(INameFactory nameFactory) {
            this.nameFactory_ = nameFactory;
            return (T)((Object)((Builder)this.self()));
        }

        public abstract T withTopic(TopicName var1);

        public T withTopics(TopicName ... topics) {
            for (TopicName name : topics) {
                this.withTopic(name);
            }
            return (T)((Object)((Builder)this.self()));
        }

        public T withTopics(String ... topics) {
            for (String name : topics) {
                this.topicIds_.add(name);
            }
            return (T)((Object)((Builder)this.self()));
        }

        public T withTopic(String name) {
            this.topicIds_.add(name);
            return (T)((Object)((Builder)this.self()));
        }

        public synchronized T withTopic(String serviceId, String topicId) {
            List<String> list = this.serviceTopicIds_.get(serviceId);
            if (list == null) {
                list = new LinkedList<String>();
                this.serviceTopicIds_.put(serviceId, list);
            }
            list.add(topicId);
            return (T)((Object)((Builder)this.self()));
        }

        public synchronized void validate(FaultAccumulator faultAccumulator) {
            faultAccumulator.checkNotNull((Object)this.nameFactory_, "nameFactory");
            for (String string : this.topicIds_) {
                this.withTopic(this.nameFactory_.getTopicName(string));
            }
            for (Map.Entry entry : this.serviceTopicIds_.entrySet()) {
                for (String topicId : (List)entry.getValue()) {
                    this.withTopic(this.nameFactory_.getTopicName((String)entry.getKey(), topicId));
                }
            }
        }
    }
}

