/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.http.resources;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.fugue.http.IResourceProvider;

public class FugueResourceProvider
implements IResourceProvider {
    private static final Logger log_ = LoggerFactory.getLogger(FugueResourceProvider.class);
    private static final String[] ALLOWED_PATHS = new String[]{"/html/", "/css/", "/images/"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String loadResourceAsString(Path path) {
        try (InputStreamReader in = new InputStreamReader(this.getResourceUrl(path).openStream());){
            int nbytes;
            StringBuffer s = new StringBuffer();
            char[] buf = new char[1024];
            while ((nbytes = in.read(buf)) > 0) {
                s.append(buf, 0, nbytes);
            }
            String string = s.toString();
            return string;
        }
        catch (IOException e) {
            log_.error("Exception closing InputStream", (Throwable)e);
            return e.toString();
        }
    }

    public URL getResourceUrl(String path) {
        if (this.pathIsDisallowed(path)) {
            return null;
        }
        return this.getClass().getResource(path);
    }

    private boolean pathIsDisallowed(String path) {
        if (path.endsWith("/")) {
            return true;
        }
        for (String prefix : ALLOWED_PATHS) {
            if (!path.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public URL getResourceUrl(Path path) {
        return this.getResourceUrl(path.toString());
    }
}

