/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.google.pubsub;

import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PushConfig;
import java.io.IOException;
import org.symphonyoss.s2.common.fault.TransactionFault;
import org.symphonyoss.s2.common.immutable.ImmutableByteArray;
import org.symphonyoss.s2.fugue.IConfigurationProvider;
import org.symphonyoss.s2.fugue.core.trace.ITraceContextFactory;
import org.symphonyoss.s2.fugue.google.pubsub.GoogleAbstractSubscriberManager;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.naming.SubscriptionName;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberAdmin;
import org.symphonyoss.s2.fugue.pubsub.Subscription;

public class GoogleSubscriberAdmin
extends GoogleAbstractSubscriberManager<GoogleSubscriberAdmin>
implements ISubscriberAdmin<ImmutableByteArray, GoogleSubscriberAdmin> {
    public GoogleSubscriberAdmin(INameFactory nameFactory, IConfigurationProvider config, ITraceContextFactory traceFactory) {
        super(GoogleSubscriberAdmin.class, nameFactory, config, traceFactory);
    }

    public void createSubscriptions() {
        for (Subscription subscription : this.getSubscribers()) {
            for (String topic : subscription.getTopicNames()) {
                TopicName topicName = this.nameFactory_.getTopicName(topic);
                SubscriptionName subscriptionName = this.nameFactory_.getSubscriptionName(topicName, subscription.getSubscriptionName());
                this.createSubcription(topicName, subscriptionName);
            }
        }
    }

    private void createSubcription(TopicName topicName, SubscriptionName subscriptionName) {
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create();){
            ProjectTopicName projectTopicName = ProjectTopicName.of((String)this.projectId_, (String)topicName.toString());
            ProjectSubscriptionName projectSubscriptionName = ProjectSubscriptionName.of((String)this.projectId_, (String)subscriptionName.toString());
            subscriptionAdminClient.createSubscription(projectSubscriptionName, projectTopicName, PushConfig.getDefaultInstance(), 0);
        }
        catch (IOException e) {
            throw new TransactionFault((Throwable)e);
        }
    }
}

