/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.google.pubsub;

import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PushConfig;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.common.fault.TransactionFault;
import org.symphonyoss.s2.common.immutable.ImmutableByteArray;
import org.symphonyoss.s2.fugue.core.trace.ITraceContextFactory;
import org.symphonyoss.s2.fugue.google.pubsub.GoogleAbstractSubscriberManager;
import org.symphonyoss.s2.fugue.naming.INameFactory;
import org.symphonyoss.s2.fugue.naming.SubscriptionName;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pubsub.ISubscriberAdmin;
import org.symphonyoss.s2.fugue.pubsub.Subscription;

public class GoogleSubscriberAdmin
extends GoogleAbstractSubscriberManager<GoogleSubscriberAdmin>
implements ISubscriberAdmin<ImmutableByteArray, GoogleSubscriberAdmin> {
    private static final Logger log_ = LoggerFactory.getLogger(GoogleSubscriberAdmin.class);

    public GoogleSubscriberAdmin(INameFactory nameFactory, String projectId, ITraceContextFactory traceFactory) {
        super(GoogleSubscriberAdmin.class, nameFactory, projectId, traceFactory);
    }

    public void createSubscriptions(boolean dryRun) {
        for (Subscription subscription : this.getSubscribers()) {
            for (String topic : subscription.getTopicNames()) {
                TopicName topicName = this.nameFactory_.getTopicName(topic);
                SubscriptionName subscriptionName = this.nameFactory_.getSubscriptionName(topicName, subscription.getSubscriptionName());
                this.createSubcription(topicName, subscriptionName, dryRun);
            }
        }
    }

    private void createSubcription(TopicName topicName, SubscriptionName subscriptionName, boolean dryRun) {
        block18: {
            try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create();){
                ProjectTopicName projectTopicName = ProjectTopicName.of((String)this.projectId_, (String)topicName.toString());
                ProjectSubscriptionName projectSubscriptionName = ProjectSubscriptionName.of((String)this.projectId_, (String)subscriptionName.toString());
                try {
                    com.google.pubsub.v1.Subscription existing = subscriptionAdminClient.getSubscription(projectSubscriptionName);
                    log_.info("Subscription " + subscriptionName + " on topic " + topicName + " already exists.");
                }
                catch (NotFoundException e) {
                    if (dryRun) {
                        log_.info("Subscription " + subscriptionName + " on topic " + topicName + " would be created (dry run).");
                        break block18;
                    }
                    subscriptionAdminClient.createSubscription(projectSubscriptionName, projectTopicName, PushConfig.getDefaultInstance(), 0);
                    log_.info("Subscription " + subscriptionName + " on topic " + topicName + " created.");
                }
            }
            catch (AlreadyExistsException e) {
                log_.info("Subscription " + subscriptionName + " on topic " + topicName + " already exists.");
            }
            catch (IOException e) {
                throw new TransactionFault((Throwable)e);
            }
        }
    }

    public void deleteSubscriptions(boolean dryRun) {
        for (Subscription subscription : this.getSubscribers()) {
            for (String topic : subscription.getTopicNames()) {
                TopicName topicName = this.nameFactory_.getTopicName(topic);
                SubscriptionName subscriptionName = this.nameFactory_.getSubscriptionName(topicName, subscription.getSubscriptionName());
                this.deleteSubcription(topicName, subscriptionName, dryRun);
            }
        }
    }

    private void deleteSubcription(TopicName topicName, SubscriptionName subscriptionName, boolean dryRun) {
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create();){
            ProjectTopicName projectTopicName = ProjectTopicName.of((String)this.projectId_, (String)topicName.toString());
            ProjectSubscriptionName projectSubscriptionName = ProjectSubscriptionName.of((String)this.projectId_, (String)subscriptionName.toString());
            com.google.pubsub.v1.Subscription existing = subscriptionAdminClient.getSubscription(projectSubscriptionName);
            if (dryRun) {
                log_.info("Subscription " + subscriptionName + " would be deleted (dry run).");
            } else {
                subscriptionAdminClient.deleteSubscription(projectSubscriptionName);
                log_.info("Subscription " + subscriptionName + " deleted.");
            }
        }
        catch (AlreadyExistsException e) {
            log_.info("Subscription " + subscriptionName + " does not exist.");
        }
        catch (IOException e) {
            throw new TransactionFault((Throwable)e);
        }
    }
}

