/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.google.pubsub;

import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PushConfig;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.common.fault.FaultAccumulator;
import org.symphonyoss.s2.fugue.naming.SubscriptionName;
import org.symphonyoss.s2.fugue.naming.TopicName;
import org.symphonyoss.s2.fugue.pubsub.AbstractSubscriberAdmin;
import org.symphonyoss.s2.fugue.pubsub.ITopicSubscriptionAdmin;

public class GoogleSubscriberAdmin
extends AbstractSubscriberAdmin<GoogleSubscriberAdmin> {
    private static final Logger log_ = LoggerFactory.getLogger(GoogleSubscriberAdmin.class);
    private String projectId_;
    private SubscriptionAdminClient subscriptionAdminClient_;

    private GoogleSubscriberAdmin(Builder builder) {
        super(GoogleSubscriberAdmin.class, (AbstractSubscriberAdmin.Builder)builder);
        this.projectId_ = builder.projectId_;
        try {
            this.subscriptionAdminClient_ = SubscriptionAdminClient.create();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create SubscriptionAdminClient", e);
        }
    }

    public synchronized void stop() {
        this.subscriptionAdminClient_.close();
        super.stop();
    }

    protected void createSubcription(SubscriptionName subscriptionName, ITopicSubscriptionAdmin subscription, boolean dryRun) {
        block7: {
            if (subscription.getFilterPropertyName() != null) {
                throw new IllegalArgumentException("Google pubsub does not support filtering.");
            }
            if (subscription.getLambdaConsumer() != null) {
                throw new IllegalArgumentException("Google pubsub does not support lambda triggers.");
            }
            TopicName topicName = subscriptionName.getTopicName();
            try {
                ProjectTopicName projectTopicName = ProjectTopicName.of((String)this.projectId_, (String)topicName.toString());
                ProjectSubscriptionName projectSubscriptionName = ProjectSubscriptionName.of((String)this.projectId_, (String)subscriptionName.toString());
                try {
                    this.subscriptionAdminClient_.getSubscription(projectSubscriptionName);
                    log_.info("Subscription " + subscriptionName + " on topic " + topicName + " already exists.");
                }
                catch (NotFoundException e) {
                    if (dryRun) {
                        log_.info("Subscription " + subscriptionName + " on topic " + topicName + " would be created (dry run).");
                        break block7;
                    }
                    this.subscriptionAdminClient_.createSubscription(projectSubscriptionName, projectTopicName, PushConfig.getDefaultInstance(), 0);
                    log_.info("Subscription " + subscriptionName + " on topic " + topicName + " created.");
                }
            }
            catch (AlreadyExistsException e) {
                log_.info("Subscription " + subscriptionName + " on topic " + topicName + " already exists.");
            }
        }
    }

    protected void deleteSubcription(SubscriptionName subscriptionName, boolean dryRun) {
        TopicName topicName = subscriptionName.getTopicName();
        log_.info("About to delete subscription " + subscriptionName + " on topic " + topicName);
        try {
            ProjectSubscriptionName projectSubscriptionName = ProjectSubscriptionName.of((String)this.projectId_, (String)subscriptionName.toString());
            this.subscriptionAdminClient_.getSubscription(projectSubscriptionName);
            if (dryRun) {
                log_.info("Subscription " + subscriptionName + " would be deleted (dry run).");
            } else {
                log_.info("About to delete subscription with name " + projectSubscriptionName);
                this.subscriptionAdminClient_.deleteSubscription(projectSubscriptionName);
                log_.info("Subscription " + subscriptionName + " deleted.");
            }
        }
        catch (NotFoundException e) {
            log_.info("Subscription " + subscriptionName + " does not exist.");
        }
    }

    public static class Builder
    extends AbstractSubscriberAdmin.Builder<Builder, GoogleSubscriberAdmin> {
        private String projectId_;

        public Builder() {
            super(Builder.class);
        }

        public Builder withProjectId(String projectId) {
            this.projectId_ = projectId;
            return (Builder)this.self();
        }

        public void validate(FaultAccumulator faultAccumulator) {
            super.validate(faultAccumulator);
            faultAccumulator.checkNotNull((Object)this.projectId_, "projectId");
        }

        protected GoogleSubscriberAdmin construct() {
            return new GoogleSubscriberAdmin(this);
        }
    }
}

