/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.s2.fugue.google.pubsub;

import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.Subscription;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.symphonyoss.s2.common.fault.FaultAccumulator;
import org.symphonyoss.s2.common.fault.ProgramFault;
import org.symphonyoss.s2.common.fault.TransactionFault;
import org.symphonyoss.s2.fugue.google.pubsub.GoogleSubscriber;
import org.symphonyoss.s2.fugue.naming.Name;
import org.symphonyoss.s2.fugue.pipeline.IThreadSafeRetryableConsumer;
import org.symphonyoss.s2.fugue.pubsub.AbstractPullSubscriberManager;
import org.symphonyoss.s2.fugue.pubsub.ISubscription;

public class GoogleSubscriberManager
extends AbstractPullSubscriberManager<GoogleSubscriberManager> {
    private static final Logger log_ = LoggerFactory.getLogger(GoogleSubscriberManager.class);
    private final String projectId_;
    private List<GoogleSubscriber> subscribers_ = new LinkedList<GoogleSubscriber>();

    private GoogleSubscriberManager(Builder builder) {
        super(GoogleSubscriberManager.class, (AbstractPullSubscriberManager.Builder)builder);
        this.projectId_ = builder.projectId_;
    }

    protected void initSubscription(ISubscription subscription) {
        try (SubscriptionAdminClient subscriptionAdminClient = SubscriptionAdminClient.create();){
            for (Name subscriptionName : subscription.getSubscriptionNames()) {
                log_.info("Validating subscription " + subscriptionName + "...");
                this.validateSubcription(subscriptionAdminClient, subscriptionName.toString());
                GoogleSubscriber subscriber = new GoogleSubscriber(this, ProjectSubscriptionName.format((String)this.projectId_, (String)subscriptionName.toString()), this.getTraceFactory(), (IThreadSafeRetryableConsumer<String>)subscription.getConsumer(), this.getCounter(), this.getBusyCounter(), this.nameFactory_.getPodName());
                this.subscribers_.add(subscriber);
                log_.info("Subscribing to " + subscriptionName + "...");
            }
        }
        catch (IOException e) {
            throw new TransactionFault((Throwable)e);
        }
    }

    private void validateSubcription(SubscriptionAdminClient subscriptionAdminClient, String subscriptionName) {
        ProjectSubscriptionName projectSubscriptionName = ProjectSubscriptionName.of((String)this.projectId_, (String)subscriptionName);
        try {
            Subscription existing = subscriptionAdminClient.getSubscription(projectSubscriptionName);
            log_.info("Subscription " + subscriptionName + " exists with ack deadline " + existing.getAckDeadlineSeconds() + " seconds.");
        }
        catch (NotFoundException e) {
            throw new ProgramFault("Subscription " + subscriptionName + " DOES NOT EXIST.");
        }
        catch (StatusRuntimeException e) {
            log_.error("Subscription " + subscriptionName + " cannot be validated - lets hope....", (Throwable)e);
        }
    }

    protected void startSubscriptions() {
        for (GoogleSubscriber subscriber : this.subscribers_) {
            log_.info("Starting subscription to " + subscriber.getSubscriptionName() + "...");
            this.submit((Runnable)((Object)subscriber), true);
        }
    }

    protected void stopSubscriptions() {
        for (GoogleSubscriber subscriber : this.subscribers_) {
            subscriber.stop();
        }
        super.stopSubscriptions();
    }

    public static class Builder
    extends AbstractPullSubscriberManager.Builder<Builder, GoogleSubscriberManager> {
        private String projectId_;

        public Builder() {
            super(Builder.class);
        }

        protected String getConfigPath() {
            return "org/symphonyoss/s2/fugue/google/pubsub";
        }

        public Builder withProjectId(String projectId) {
            this.projectId_ = projectId;
            return (Builder)this.self();
        }

        public void validate(FaultAccumulator faultAccumulator) {
            super.validate(faultAccumulator);
            faultAccumulator.checkNotNull((Object)this.projectId_, "projectId");
        }

        protected GoogleSubscriberManager construct() {
            return new GoogleSubscriberManager(this);
        }
    }
}

