/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication;

import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;
import org.symphonyoss.symphony.apps.authentication.AppAuthenticationApiClient;
import org.symphonyoss.symphony.apps.authentication.AppAuthenticationException;
import org.symphonyoss.symphony.apps.authentication.tokens.StoreTokensProvider;
import org.symphonyoss.symphony.apps.authentication.tokens.StoreTokensProviderFactory;
import org.symphonyoss.symphony.apps.authentication.tokens.model.AppToken;

public class AppAuthenticationService {
    private SecureRandom secureRandom = new SecureRandom();
    private AppAuthenticationApiClient apiClient = new AppAuthenticationApiClient();
    private StoreTokensProviderFactory factory = StoreTokensProviderFactory.getInstance();

    public AppToken authenticate(String appId) throws AppAuthenticationException {
        String appToken = this.generateToken();
        AppToken result = this.apiClient.authenticate(appId, appToken);
        StoreTokensProvider provider = (StoreTokensProvider)this.factory.getComponent();
        provider.saveAppAuthenticationToken(result);
        return result;
    }

    private String generateToken() {
        byte[] randBytes = new byte[64];
        this.secureRandom.nextBytes(randBytes);
        return Hex.encodeHexString((byte[])randBytes);
    }

    public boolean isValidTokenPair(String applicationToken, String symphonyToken) {
        StoreTokensProvider provider = (StoreTokensProvider)this.factory.getComponent();
        AppToken token = provider.getAppAuthenticationToken(applicationToken);
        if (token == null) {
            return false;
        }
        return symphonyToken.equals(token.getSymphonyToken());
    }
}

