/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.certificate;

import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.symphonyoss.symphony.apps.authentication.certificate.PodCertificateClient;
import org.symphonyoss.symphony.apps.authentication.certificate.PodCertificateClientFactory;
import org.symphonyoss.symphony.apps.authentication.certificate.exception.PodCertificateException;
import org.symphonyoss.symphony.apps.authentication.certificate.model.PodCertificate;

public class PodCertificateService {
    private PodCertificateClientFactory factory = PodCertificateClientFactory.getInstance();

    public PublicKey getPodPublicKey() throws PodCertificateException {
        PodCertificate pem = ((PodCertificateClient)this.factory.getComponent()).getPodPublicCertificate();
        return this.readPublicKey(pem);
    }

    private PublicKey readPublicKey(PodCertificate certificate) throws PodCertificateException {
        try {
            String encoded = certificate.getCertificate().replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
            byte[] decoded = Base64.decodeBase64((String)encoded);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(decoded));
            return x509Certificate.getPublicKey();
        }
        catch (CertificateException e) {
            throw new PodCertificateException("Cannot retrieve public key from X.509 certificate", e);
        }
    }
}

