/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.jwt;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.symphonyoss.symphony.apps.authentication.certificate.PodCertificateService;
import org.symphonyoss.symphony.apps.authentication.certificate.exception.PodCertificateException;
import org.symphonyoss.symphony.apps.authentication.json.JsonParser;
import org.symphonyoss.symphony.apps.authentication.json.JsonParserFactory;
import org.symphonyoss.symphony.apps.authentication.jwt.exception.JwtProcessingException;
import org.symphonyoss.symphony.apps.authentication.jwt.model.JwtPayload;

public class JwtService {
    private static final String CERT_KEY = "certificate";
    private LoadingCache<String, PublicKey> podPublicSignatureVerifierCache;
    private LoadingCache<String, JwtPayload> jwtPayloadCache;
    private final Integer cacheTimeoutInMinutes;
    private final Integer maxCacheSize;
    private PodCertificateService certificateService = new PodCertificateService();
    private JsonParserFactory factory = JsonParserFactory.getInstance();
    private JwtParser parser = Jwts.parser();

    public JwtService(Integer cacheTimeoutInMinutes, Integer maxCacheSize) {
        this.cacheTimeoutInMinutes = cacheTimeoutInMinutes;
        this.maxCacheSize = maxCacheSize;
        this.initializePodCertificateCache();
        this.initializeJwtPayloadCache();
    }

    private void initializePodCertificateCache() {
        this.podPublicSignatureVerifierCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheTimeoutInMinutes.intValue(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, PublicKey>(){

            public PublicKey load(String key) throws PodCertificateException {
                return JwtService.this.certificateService.getPodPublicKey();
            }
        });
    }

    private void initializeJwtPayloadCache() {
        this.jwtPayloadCache = CacheBuilder.newBuilder().maximumSize((long)this.maxCacheSize.intValue()).build((CacheLoader)new CacheLoader<String, JwtPayload>(){

            public JwtPayload load(String jwt) throws JwtProcessingException {
                return JwtService.this.loadJwtPayload(jwt);
            }
        });
    }

    public JwtPayload parseJwtPayload(String jwt) throws JwtProcessingException {
        try {
            return (JwtPayload)this.jwtPayloadCache.get((Object)jwt);
        }
        catch (ExecutionException e) {
            JwtProcessingException cause = (JwtProcessingException)e.getCause();
            throw cause;
        }
    }

    private JwtPayload loadJwtPayload(String jwt) throws JwtProcessingException {
        try {
            PublicKey rsaVerifier = this.getPublicKey();
            Jws<Claims> jws = this.getClaims(jwt, rsaVerifier);
            return this.getPayload(jws);
        }
        catch (PodCertificateException e) {
            throw new JwtProcessingException(e.getMessage(), e);
        }
    }

    private PublicKey getPublicKey() throws PodCertificateException {
        try {
            return (PublicKey)this.podPublicSignatureVerifierCache.get((Object)CERT_KEY);
        }
        catch (ExecutionException e) {
            PodCertificateException cause = (PodCertificateException)e.getCause();
            throw cause;
        }
    }

    private Jws<Claims> getClaims(String jwt, PublicKey rsaVerifier) throws JwtProcessingException {
        try {
            return this.parser.setSigningKey((Key)rsaVerifier).parseClaimsJws(jwt);
        }
        catch (JwtException e) {
            throw new JwtProcessingException(e.getMessage(), e);
        }
    }

    private JwtPayload getPayload(Jws<Claims> jwt) throws JwtProcessingException {
        try {
            JsonParser parser = (JsonParser)this.factory.getComponent();
            String json = parser.writeToString(jwt.getBody());
            return parser.writeToObject(json, JwtPayload.class);
        }
        catch (IOException e) {
            throw new JwtProcessingException("Invalid JWT", e);
        }
    }
}

