/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.apps.authentication.spring;

import org.symphonyoss.symphony.apps.authentication.endpoints.ServicesInfoProvider;
import org.symphonyoss.symphony.apps.authentication.spring.properties.AuthenticationProperties;
import org.symphonyoss.symphony.apps.authentication.spring.properties.ServiceAddress;

public class SpringServiceInfoProvider
implements ServicesInfoProvider {
    private static final String POD_CONTEXT = "pod";
    private static final String SESSION_AUTH_CONTEXT = "sessionauth";
    private final AuthenticationProperties properties;
    private String podUrl;
    private String sessionAuthUrl;

    public SpringServiceInfoProvider(AuthenticationProperties properties) {
        this.properties = properties;
        if (properties == null) {
            throw new IllegalArgumentException("Missing service addresses");
        }
        this.podUrl = this.getPodUrl();
        this.sessionAuthUrl = this.getSessionAuthUrl();
    }

    private String getPodUrl() {
        ServiceAddress address = this.properties.getPod();
        if (address == null) {
            throw new IllegalArgumentException("POD address not provided");
        }
        return address.getUrl(POD_CONTEXT);
    }

    private String getSessionAuthUrl() {
        ServiceAddress address = this.properties.getSessionAuth();
        if (address == null) {
            throw new IllegalArgumentException("Session auth address not provided");
        }
        return address.getUrl(SESSION_AUTH_CONTEXT);
    }

    public String getPodBaseUrl() {
        return this.podUrl;
    }

    public String getSessionAuthBaseUrl() {
        return this.sessionAuthUrl;
    }
}

