/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.bi.BiItem;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.FormElement;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.elements.LabelableElement;
import org.symphonyoss.symphony.messageml.elements.TooltipableElement;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.exceptions.ProcessingException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.PersonSelectorNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PersonSelector
extends FormElement
implements LabelableElement,
TooltipableElement {
    public static final String MESSAGEML_TAG = "person-selector";
    private static final String PLACEHOLDER_ATTR = "placeholder";
    private static final String REQUIRED_ATTR = "required";
    private static final Set<String> VALID_VALUES_FOR_REQUIRED_ATTR = new HashSet<String>(Arrays.asList("true", "false"));
    private static final String VALUE_ATTR = "value";
    private static final String PRESENTATIONML_TAG = "div";
    private static final String PRESENTATIONML_PLACEHOLDER_ATTR = "data-placeholder";
    private static final String PRESENTATIONML_REQUIRED_ATTR = "data-required";
    private static final String PRESENTATIONML_VALUE_ATTR = "data-value";
    private static final String MARKDOWN = "Person Selector";
    private static final String CLASS_ATTR = "class";
    private static final String PRESENTATIONML_NAME_ATTR = "data-name";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public PersonSelector(Element parent, FormatEnum messageFormat) {
        super(parent, MESSAGEML_TAG, messageFormat);
    }

    @Override
    public void buildAll(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        switch (this.getFormat()) {
            case MESSAGEML: {
                super.buildAll(parser, element);
                break;
            }
            case PRESENTATIONML: {
                this.buildElementFromDiv(parser, element);
                this.validate();
                break;
            }
            default: {
                throw new InvalidInputException(String.format("Invalid message format for \"%s\" element", MESSAGEML_TAG));
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        if (this.getAttribute("name") == null) {
            throw new InvalidInputException("The attribute \"name\" is required");
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            this.assertAttributeValue(REQUIRED_ATTR, VALID_VALUES_FOR_REQUIRED_ATTR);
        }
        if (this.getAttribute(VALUE_ATTR) != null) {
            try {
                MAPPER.readValue(this.getAttribute(VALUE_ATTR), (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, Long.class));
            }
            catch (JsonProcessingException e) {
                throw new InvalidInputException(String.format("Attribute \"%s\" contains an unsupported format, should be an array of user ids", VALUE_ATTR));
            }
        }
        this.assertNoContent();
        this.assertAttributeNotBlank("name");
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        Map<String, String> presentationAttrs = this.buildPersonSelectorInputAttributes();
        if (this.isSplittable()) {
            presentationAttrs.put("id", this.splittableAsPresentationML(out, context));
            this.innerAsPresentationML(out, presentationAttrs);
            out.closeElement();
        } else {
            this.innerAsPresentationML(out, presentationAttrs);
        }
    }

    private void innerAsPresentationML(XmlPrintStream out, Map<String, String> presentationAttrs) {
        out.openElement(PRESENTATIONML_TAG, presentationAttrs);
        out.closeElement();
    }

    @Override
    public Node asMarkdown() {
        return new PersonSelectorNode(this.getAttribute(PLACEHOLDER_ATTR), this.getAttribute("label"), this.getAttribute("title"));
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "name": 
            case "placeholder": 
            case "required": 
            case "label": 
            case "title": 
            case "value": {
                this.setAttribute(item.getNodeName(), this.getStringAttribute(item));
                break;
            }
            case "id": {
                if (this.format != FormatEnum.PRESENTATIONML) {
                    this.throwInvalidInputException(item);
                }
                this.fillAttributes(parser, item);
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    private Map<String, String> buildPersonSelectorInputAttributes() {
        LinkedHashMap<String, String> presentationAttrs = new LinkedHashMap<String, String>();
        presentationAttrs.put(CLASS_ATTR, MESSAGEML_TAG);
        presentationAttrs.put(PRESENTATIONML_NAME_ATTR, this.getAttribute("name"));
        if (this.getAttribute(PLACEHOLDER_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_PLACEHOLDER_ATTR, this.getAttribute(PLACEHOLDER_ATTR));
        }
        if (this.getAttribute(REQUIRED_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_REQUIRED_ATTR, this.getAttribute(REQUIRED_ATTR));
        }
        if (this.getAttribute(VALUE_ATTR) != null) {
            presentationAttrs.put(PRESENTATIONML_VALUE_ATTR, this.getAttribute(VALUE_ATTR));
        }
        return presentationAttrs;
    }

    private void buildElementFromDiv(MessageMLParser parser, org.w3c.dom.Element element) throws InvalidInputException, ProcessingException {
        element.setAttribute("name", element.getAttribute(PRESENTATIONML_NAME_ATTR));
        element.removeAttribute(PRESENTATIONML_NAME_ATTR);
        if (element.hasAttribute(PRESENTATIONML_PLACEHOLDER_ATTR)) {
            element.setAttribute(PLACEHOLDER_ATTR, element.getAttribute(PRESENTATIONML_PLACEHOLDER_ATTR));
            element.removeAttribute(PRESENTATIONML_PLACEHOLDER_ATTR);
        }
        if (element.hasAttribute(PRESENTATIONML_REQUIRED_ATTR)) {
            element.setAttribute(REQUIRED_ATTR, element.getAttribute(PRESENTATIONML_REQUIRED_ATTR));
            element.removeAttribute(PRESENTATIONML_REQUIRED_ATTR);
        }
        if (element.hasAttribute(PRESENTATIONML_VALUE_ATTR)) {
            element.setAttribute(VALUE_ATTR, element.getAttribute(PRESENTATIONML_VALUE_ATTR));
            element.removeAttribute(PRESENTATIONML_VALUE_ATTR);
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.buildAttribute(parser, attributes.item(i));
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.buildNode(parser, children.item(i));
        }
    }

    @Override
    public String getPresentationMLTag() {
        return PRESENTATIONML_TAG;
    }

    @Override
    public String getElementId() {
        return MESSAGEML_TAG;
    }

    @Override
    public void updateBiContext(BiContext context) {
        HashMap<String, Object> attributesMapBi = new HashMap<String, Object>();
        this.putOneIfPresent(attributesMapBi, BiFields.TITLE.getValue(), "title");
        this.putOneIfPresent(attributesMapBi, BiFields.LABEL.getValue(), "label");
        this.putOneIfPresent(attributesMapBi, BiFields.PLACEHOLDER.getValue(), PLACEHOLDER_ATTR);
        this.putOneIfPresent(attributesMapBi, BiFields.REQUIRED.getValue(), REQUIRED_ATTR);
        context.addItem(new BiItem(BiFields.PERSON_SELECTOR.getValue(), attributesMapBi));
    }
}

