/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.util.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "time", "from", "to"})
public class TimeInterval
implements Serializable {
    private String time;
    private String from;
    private String to;
    @JsonIgnore
    private static final String TIME = "time";
    @JsonIgnore
    private static final String RANGE = "range";

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    @JsonIgnore
    public void assertIsValid() throws InvalidInputException {
        String type = this.getType();
        if (TIME.equals(type)) {
            this.assertTimeFormat(this.time);
        } else if (RANGE.equals(type)) {
            this.assertTimeFormat(this.from);
            this.assertTimeFormat(this.to);
        } else {
            throw new InvalidInputException("Time interval 'type' is unknown or null");
        }
    }

    public String getType() {
        if (this.time != null && this.from == null && this.to == null) {
            return TIME;
        }
        if (this.time == null && this.from != null && this.to != null) {
            return RANGE;
        }
        return null;
    }

    private void assertTimeFormat(String time) throws InvalidInputException {
        try {
            LocalTime.parse(time, DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
        catch (DateTimeParseException e) {
            throw new InvalidInputException(String.format("\"%s\" is not a valid time, only HH:mm:ss format is allowed", time), e);
        }
    }
}

