/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commonmark.node.Node;
import org.symphonyoss.symphony.messageml.MessageMLContext;
import org.symphonyoss.symphony.messageml.MessageMLParser;
import org.symphonyoss.symphony.messageml.bi.BiContext;
import org.symphonyoss.symphony.messageml.bi.BiFields;
import org.symphonyoss.symphony.messageml.elements.DialogChild;
import org.symphonyoss.symphony.messageml.elements.Element;
import org.symphonyoss.symphony.messageml.elements.Form;
import org.symphonyoss.symphony.messageml.elements.FormatEnum;
import org.symphonyoss.symphony.messageml.exceptions.InvalidInputException;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.DialogNode;
import org.symphonyoss.symphony.messageml.util.ShortID;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class Dialog
extends Element {
    public static final String MESSAGEML_TAG = "dialog";
    public static final String STATE_ATTR = "state";
    public static final String CLOSE_STATE = "close";
    public static final List<String> ALLOWED_STATE_VALUES = Arrays.asList("open", "close");
    public static final String WIDTH_ATTR = "width";
    public static final String MEDIUM_WIDTH = "medium";
    public static final List<String> ALLOWED_WIDTH_VALUES = Arrays.asList("small", "medium", "large", "full-width");
    private static final String DATA_ATTRIBUTE_PREFIX = "data-";
    private static final String OPEN_ATTR = "open";
    public static final String PRESENTATIONML_CLASS = "dialog";
    private static final ShortID SHORT_ID = new ShortID();
    private String presentationMlIdAttribute = null;

    public Dialog(Element parent, FormatEnum format) {
        super(parent, "dialog", format);
    }

    @Override
    public Boolean hasIdAttribute() {
        return true;
    }

    @Override
    protected void buildAttribute(MessageMLParser parser, org.w3c.dom.Node item) throws InvalidInputException {
        switch (item.getNodeName()) {
            case "data-width": 
            case "width": 
            case "data-state": 
            case "state": 
            case "data-open": 
            case "id": {
                this.setAttribute(item.getNodeName().replace(DATA_ATTRIBUTE_PREFIX, ""), item.getNodeValue());
                break;
            }
            case "open": {
                if (this.format == FormatEnum.MESSAGEML) {
                    this.throwInvalidInputException(item);
                }
                this.setAttribute(item.getNodeName(), item.getNodeValue());
                break;
            }
            default: {
                this.throwInvalidInputException(item);
            }
        }
    }

    @Override
    public void validate() throws InvalidInputException {
        super.validate();
        this.checkAttributes();
        this.validateChildrenTypes();
    }

    @Override
    public void asPresentationML(XmlPrintStream out, MessageMLContext context) {
        out.openElement(this.getPresentationMLTag(), this.getPresentationMLAttributes());
        for (Element child : this.getChildren()) {
            child.asPresentationML(out, context);
        }
        out.closeElement();
    }

    @Override
    Node asMarkdown() throws InvalidInputException {
        return new DialogNode();
    }

    @Override
    void updateBiContext(BiContext context) {
        super.updateBiContext(context);
        context.updateItemCount(BiFields.POPUPS.getValue());
    }

    public String getPresentationMlIdAttribute() {
        if (this.presentationMlIdAttribute == null) {
            this.presentationMlIdAttribute = SHORT_ID.generate() + "-" + this.getAttribute("id");
        }
        return this.presentationMlIdAttribute;
    }

    private void checkAttributes() throws InvalidInputException {
        this.validateIdAttribute("id");
        this.checkAttributeOrPutDefaultValue(WIDTH_ATTR, MEDIUM_WIDTH, ALLOWED_WIDTH_VALUES);
        this.checkAttributeOrPutDefaultValue(STATE_ATTR, CLOSE_STATE, ALLOWED_STATE_VALUES);
    }

    private void checkAttributeOrPutDefaultValue(String attributeName, String defaultValue, List<String> allowedValues) throws InvalidInputException {
        if (this.getAttribute(attributeName) == null) {
            this.setAttribute(attributeName, defaultValue);
        }
        this.assertAttributeValue(attributeName, allowedValues);
    }

    private void validateChildrenTypes() throws InvalidInputException {
        long formsCount = this.getChildren().stream().filter(element -> element instanceof Form).count();
        if (formsCount == 1L) {
            this.assertContentModel(Collections.singleton(Form.class), "A \"dialog\" element can't contain a \"form\" element and any other element.");
        } else {
            if (formsCount > 1L) {
                throw new InvalidInputException("A \"dialog\" element can contain only one \"form\" element");
            }
            if (this.format == FormatEnum.MESSAGEML) {
                this.assertContainsAlwaysChildOfType(Collections.singleton(DialogChild.Title.class));
                this.assertContainsAlwaysChildOfType(Collections.singleton(DialogChild.Body.class));
                this.assertContentModel(Arrays.asList(DialogChild.Footer.class, DialogChild.Title.class, DialogChild.Body.class));
            } else {
                this.assertContainsAlwaysChildMatching(e -> e.isPresentationMLElement("dialog-title") || e.isPresentationMLElement("dialog-body"), "The \"dialog\" element must have at least one child that is any of the following elements: [title,body].");
                this.assertContentModel((Element e) -> e.isPresentationMLElement("dialog-title") || e.isPresentationMLElement("dialog-body") || e.isPresentationMLElement("dialog-footer"), (Element child) -> "Element \"" + child.getMessageMLTag() + "\" is not allowed in \"" + this.getMessageMLTag() + "\"");
            }
        }
    }

    private Map<String, String> getPresentationMLAttributes() {
        HashMap<String, String> pmlAttributes = new HashMap<String, String>();
        if (this.format == FormatEnum.MESSAGEML) {
            pmlAttributes.put(OPEN_ATTR, "");
        }
        for (Map.Entry<String, String> mmlAttribute : this.getAttributes().entrySet()) {
            if (mmlAttribute.getKey().equals("id")) {
                pmlAttributes.put(mmlAttribute.getKey(), this.getPresentationMlIdAttribute());
                continue;
            }
            if (mmlAttribute.getKey().equals(OPEN_ATTR)) {
                pmlAttributes.put(OPEN_ATTR, "");
                continue;
            }
            pmlAttributes.put(DATA_ATTRIBUTE_PREFIX + mmlAttribute.getKey(), mmlAttribute.getValue());
        }
        return pmlAttributes;
    }
}

