/*
 * Decompiled with CFR 0.152.
 */
package org.symphonyoss.symphony.messageml.markdown;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BulletList;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Delimited;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.renderer.text.TextContentWriter;
import org.symphonyoss.symphony.messageml.markdown.nodes.EmojiNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.KeywordNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.MentionNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.PreformattedNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableCellNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.TableRowNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.ButtonNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormElementNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.FormNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.OptionNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.PersonSelectorNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.SelectNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.TextAreaNode;
import org.symphonyoss.symphony.messageml.markdown.nodes.form.TextFieldNode;
import org.symphonyoss.symphony.messageml.util.XmlPrintStream;

public class MarkdownRenderer
extends AbstractVisitor {
    private static final String TEXT = "text";
    private static final String EXPANDED_URL = "expandedUrl";
    private static final String ID = "id";
    private static final String INDEX_START = "indexStart";
    private static final String INDEX_END = "indexEnd";
    private static final String TYPE = "type";
    private static final String SCREEN_NAME = "screenName";
    private static final String PRETTY_NAME = "prettyName";
    private static final String USER_TYPE = "userType";
    private static final String USER_MENTIONS = "userMentions";
    private static final String HASHTAGS = "hashtags";
    private static final String URLS = "urls";
    private static final String INDENT = "  ";
    private static final Pattern NOESCAPE_PATTERN = Pattern.compile("^\\s*([_*\\-+`])\\1*\\s*$");
    private final TrackingWriter writer = new TrackingWriter(new StringBuilder());
    private final ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
    private boolean removeNewlines = true;
    private Character bulletListMarker;
    private int bulletListLevel = 0;
    private Integer orderedListCounter;
    private Character orderedListDelimiter;
    private int orderedListLevel = 0;

    public MarkdownRenderer(Document document) {
        this.visit(document);
    }

    public void visit(Document document) {
        this.visitChildren((Node)document);
    }

    public void visit(Text text) {
        String content = text.getLiteral();
        if (this.removeNewlines) {
            content = XmlPrintStream.removeNewLines(content);
        }
        this.writer.write(MarkdownRenderer.addEscapeCharacter(content));
    }

    public void visit(HardLineBreak hardLineBreak) {
        this.writer.line();
    }

    public void visit(Paragraph paragraph) {
        this.writer.doubleLine();
        if (paragraph.getFirstChild() != null) {
            this.visitChildren((Node)paragraph);
            this.writer.doubleLine();
        }
    }

    public void visit(Emphasis em) {
        this.visitDelimited((Delimited)em);
    }

    public void visit(StrongEmphasis b) {
        this.visitDelimited((Delimited)b);
    }

    public void visit(Link a) {
        String href = a.getDestination();
        String title = (String)StringUtils.defaultIfBlank((CharSequence)a.getTitle(), (CharSequence)a.getDestination());
        String markdown = MessageFormat.format("[ {0} ]({1})", title, href);
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put(ID, href);
        node.put(TYPE, "URL");
        node.put(INDEX_END, this.writer.length() + markdown.length());
        node.put(INDEX_START, this.writer.length());
        node.put(TEXT, title);
        node.put(EXPANDED_URL, href);
        this.putJsonObject(URLS, (JsonNode)node);
        this.writer.write(markdown);
    }

    public void visit(BulletList ul) {
        this.writer.line();
        Character previousMarker = this.bulletListMarker;
        int previousLevel = this.bulletListLevel;
        this.bulletListLevel += ul.getParent() instanceof ListItem ? 1 : 0;
        this.bulletListMarker = Character.valueOf(ul.getBulletMarker());
        this.visitChildren((Node)ul);
        this.writer.line();
        this.bulletListMarker = previousMarker;
        this.bulletListLevel = previousLevel;
        this.writer.line();
    }

    public void visit(OrderedList ol) {
        this.writer.line();
        Integer previousCounter = this.orderedListCounter;
        Character previousDelimiter = this.orderedListDelimiter;
        int previousLevel = this.orderedListLevel;
        this.orderedListLevel += ol.getParent() instanceof ListItem ? 1 : 0;
        this.orderedListCounter = ol.getStartNumber();
        this.orderedListDelimiter = Character.valueOf(ol.getDelimiter());
        this.visitChildren((Node)ol);
        this.writer.line();
        this.orderedListCounter = previousCounter;
        this.orderedListDelimiter = previousDelimiter;
        this.orderedListLevel = previousLevel;
        this.writer.line();
    }

    public void visit(ListItem li) {
        if (this.orderedListCounter != null) {
            this.writer.write(StringUtils.repeat((String)INDENT, (int)this.orderedListLevel) + String.valueOf(this.orderedListCounter) + this.orderedListDelimiter + " ");
            this.visitChildren((Node)li);
            this.writer.line();
            Integer n = this.orderedListCounter;
            Integer n2 = this.orderedListCounter = Integer.valueOf(this.orderedListCounter + 1);
        } else if (this.bulletListMarker != null) {
            this.writer.write(StringUtils.repeat((String)INDENT, (int)this.bulletListLevel) + this.bulletListMarker + " ");
            this.visitChildren((Node)li);
            this.writer.line();
        }
    }

    public void visit(FencedCodeBlock code) {
        this.writer.line();
        this.writer.writeStripped(StringUtils.repeat((char)code.getFenceChar(), (int)code.getFenceLength()));
        if (code.getInfo() != null) {
            this.writer.write(code.getInfo());
        }
        this.writer.line();
        this.visitChildren((Node)code, Collections.singleton(Text.class));
        this.writer.line();
        this.writer.writeStripped(StringUtils.repeat((char)code.getFenceChar(), (int)code.getFenceLength()));
        this.writer.line();
    }

    public void visit(CustomNode node) {
        if (node instanceof KeywordNode) {
            this.visit((KeywordNode)node);
        } else if (node instanceof EmojiNode) {
            this.visit((EmojiNode)node);
        } else if (node instanceof MentionNode) {
            this.visit((MentionNode)node);
        }
    }

    public void visit(CustomBlock node) {
        if (node instanceof TableNode) {
            this.visit((TableNode)node);
        } else if (node instanceof TableRowNode) {
            this.visit((TableRowNode)node);
        } else if (node instanceof TableCellNode) {
            this.visit((TableCellNode)node);
        } else if (node instanceof PreformattedNode) {
            this.visit((PreformattedNode)node);
        } else if (node instanceof FormNode) {
            this.visit((FormNode)node);
        } else if (node instanceof SelectNode) {
            this.visit((SelectNode)node);
        } else if (node instanceof OptionNode) {
            this.visit((OptionNode)node);
        } else if (node instanceof ButtonNode) {
            this.visit((ButtonNode)node);
        } else if (node instanceof TextFieldNode) {
            this.visit((TextFieldNode)node);
        } else if (node instanceof TextAreaNode) {
            this.visit((TextAreaNode)node);
        } else if (node instanceof PersonSelectorNode) {
            this.visit((PersonSelectorNode)node);
        } else if (node instanceof FormElementNode) {
            this.visit((FormElementNode)node);
        }
    }

    private void visit(EmojiNode emoji) {
        this.writer.write(emoji.getOpeningDelimiter());
        this.writer.write(emoji.getShortcode());
        this.writer.write(emoji.getClosingDelimiter());
    }

    private void visit(FormElementNode formElement) {
        this.writer.write(formElement.getOpeningDelimiter());
        this.writer.write(MarkdownRenderer.addEscapeCharacter(formElement.getText()));
        this.writer.write(formElement.getClosingDelimiter());
    }

    private void visit(FormNode form) {
        this.writer.write(form.getOpeningDelimiter());
        this.visitChildren((Node)form);
        this.writer.write(form.getClosingDelimiter());
    }

    private void visit(ButtonNode button) {
        this.writer.write(button.getOpeningDelimiter());
        this.visitChildren((Node)button);
        this.writer.write(button.getClosingDelimiter());
    }

    private void visit(SelectNode select) {
        this.writer.write(select.getOpeningDelimiter());
        this.writer.write(MarkdownRenderer.addEscapeCharacter(select.getText()));
        this.writer.write(select.getClosingDelimiter());
        this.visitChildren((Node)select);
    }

    private void visit(OptionNode option) {
        this.writer.write(option.getOpeningDelimiter());
        this.visitChildren((Node)option);
        this.writer.write(option.getClosingDelimiter());
    }

    private void visit(TextFieldNode textField) {
        this.writer.write(textField.getOpeningDelimiter());
        this.writer.write(MarkdownRenderer.addEscapeCharacter(textField.getText()));
        this.writer.write(textField.getClosingDelimiter());
    }

    private void visit(TextAreaNode textArea) {
        this.writer.write(textArea.getOpeningDelimiter());
        this.writer.write(MarkdownRenderer.addEscapeCharacter(textArea.getText()));
        this.writer.write(textArea.getClosingDelimiter());
    }

    private void visit(PersonSelectorNode personSelector) {
        this.writer.write(personSelector.getOpeningDelimiter());
        this.writer.write(MarkdownRenderer.addEscapeCharacter(personSelector.getText()));
        this.writer.write(personSelector.getClosingDelimiter());
    }

    private void visit(KeywordNode keyword) {
        String text = keyword.getPrefix() + keyword.getText();
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put(ID, text);
        node.put(TEXT, text);
        node.put(INDEX_START, this.writer.length());
        node.put(INDEX_END, this.writer.length() + text.length());
        node.put(TYPE, "KEYWORD");
        this.putJsonObject(HASHTAGS, (JsonNode)node);
        this.writer.write(text);
    }

    private void visit(MentionNode mention) {
        String text = mention.getText();
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put(ID, mention.getUid());
        node.put(SCREEN_NAME, mention.getScreenName());
        node.put(PRETTY_NAME, mention.getPrettyName());
        node.put(TEXT, text);
        node.put(INDEX_START, this.writer.length());
        node.put(INDEX_END, this.writer.length() + text.length());
        node.put(USER_TYPE, "lc");
        node.put(TYPE, "USER_FOLLOW");
        this.putJsonObject(USER_MENTIONS, (JsonNode)node);
        this.writer.write(text);
    }

    private void visit(TableNode table) {
        this.writer.write(table.getOpeningDelimiter());
        this.visitChildren((Node)table);
        this.writer.write(table.getClosingDelimiter());
    }

    private void visit(TableRowNode row) {
        this.visitChildren((Node)row);
        if (row.getNext() != null) {
            this.writer.write(row.getDelimiter());
        }
    }

    private void visit(TableCellNode cell) {
        this.visitChildren((Node)cell);
        if (cell.getNext() != null) {
            this.writer.write(cell.getDelimiter());
        }
    }

    private void visit(PreformattedNode pre) {
        this.removeNewlines = false;
        this.writer.write(pre.getOpeningDelimiter());
        this.visitChildren((Node)pre);
        this.writer.write(pre.getClosingDelimiter());
        this.writer.line();
        this.removeNewlines = true;
    }

    private void visitDelimited(Delimited delimited) {
        this.writer.write(delimited.getOpeningDelimiter());
        this.visitChildren((Node)delimited);
        this.writer.write(delimited.getClosingDelimiter());
    }

    private void visitChildren(Node parent, Collection<Class<? extends Node>> includeNodes) {
        Node child = parent.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (includeNodes.contains(child.getClass())) {
                child.accept((Visitor)this);
            } else {
                this.visitChildren(child, includeNodes);
            }
            child = next;
        }
    }

    public static String addEscapeCharacter(String content) {
        Matcher matcher = NOESCAPE_PATTERN.matcher(content);
        if (!matcher.matches()) {
            content = StringUtils.replaceEach((String)content, (String[])new String[]{"_", "*", "-", "+", "`"}, (String[])new String[]{"\\_", "\\*", "\\-", "\\+", "\\`"});
        }
        return content;
    }

    private void putJsonObject(String field, JsonNode value) {
        if (!this.json.has(field)) {
            this.json.set(field, (JsonNode)new ArrayNode(JsonNodeFactory.instance));
        }
        ((ArrayNode)this.json.get(field)).add(value);
    }

    public String getText() {
        return this.writer.toString();
    }

    public ObjectNode getJson() {
        return this.json;
    }

    class TrackingWriter
    extends TextContentWriter {
        final StringBuilder out;

        TrackingWriter(StringBuilder out) {
            super((Appendable)out);
            this.out = out;
        }

        int length() {
            return this.out.length();
        }

        char getLastChar() {
            int length = this.length();
            return length != 0 ? this.out.charAt(length - 1) : (char)'\u0000';
        }

        void doubleLine() {
            char lastChar = this.getLastChar();
            if (lastChar != '\u0000' && lastChar != '\n') {
                this.write("\n\n");
            }
        }

        public String toString() {
            return this.out.toString();
        }
    }
}

